/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.analysis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aksw.commons.collections.multimaps.MultimapUtils;
import org.aksw.commons.collections.trees.Tree;
import org.aksw.jena_sparql_api.algebra.analysis.VarUsage;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.OpVisitorBase;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVars;

public class VarUsageAnalyzerVisitor
extends OpVisitorBase {
    protected Tree<Op> tree;
    protected Op current;
    protected Set<Var> availableVars;
    protected Set<Var> referencedVars;
    protected Set<Var> nonUnique;
    protected Multimap<Var, Var> varDeps;
    protected Set<Set<Var>> uniqueSets;

    public VarUsageAnalyzerVisitor(Tree<Op> tree, Op current) {
        this(tree, current, OpVars.visibleVars((Op)current));
    }

    public VarUsageAnalyzerVisitor(Tree<Op> tree, Op current, Set<Var> availableVars) {
        this.tree = tree;
        this.current = current;
        this.availableVars = availableVars;
        this.referencedVars = new HashSet<Var>();
        this.nonUnique = new HashSet<Var>();
        this.varDeps = HashMultimap.create();
        this.uniqueSets = new HashSet<Set<Var>>();
        availableVars.forEach(v -> this.varDeps.put(v, v));
    }

    public VarUsage getResult() {
        VarUsage result = new VarUsage(this.referencedVars, this.nonUnique, this.varDeps, this.uniqueSets);
        return result;
    }

    public void setCurrent(Op current) {
        this.current = current;
    }

    public void processExtend(VarExprList vel) {
        HashMultimap updates = HashMultimap.create();
        vel.forEachVarExpr((arg_0, arg_1) -> this.lambda$processExtend$2((Multimap)updates, arg_0, arg_1));
        updates.asMap().forEach((k, w) -> this.varDeps.replaceValues(k, (Iterable)w));
    }

    public void processExprs(ExprList exprs) {
        if (exprs != null) {
            Set vms = ExprVars.getVarsMentioned((ExprList)exprs);
            Set originalVars = MultimapUtils.getAll(this.varDeps, (Collection)vms);
            this.referencedVars.addAll(originalVars);
        }
    }

    public void processExpr(Expr expr) {
        if (expr != null) {
            Set vms = ExprVars.getVarsMentioned((Expr)expr);
            Set originalVars = MultimapUtils.getAll(this.varDeps, (Collection)vms);
            this.referencedVars.addAll(originalVars);
        }
    }

    public void processJoin(Collection<Op> children) {
        HashSet visibleVars = new HashSet();
        for (Op child : children) {
            if (child == this.current) continue;
            OpVars.visibleVars((Op)child, visibleVars);
        }
        Set originalVars = MultimapUtils.getAll(this.varDeps, visibleVars);
        this.referencedVars.addAll(originalVars);
    }

    public void processDistinct() {
        Set vars = this.varDeps.keySet();
        Set origVars = MultimapUtils.getAll(this.varDeps, (Collection)vars);
        this.nonUnique.forEach(origVars::remove);
        this.uniqueSets.add(origVars);
    }

    public void visit(OpProject op) {
        List opVars = op.getVars();
        HashSet removals = new HashSet(this.varDeps.keySet());
        removals.removeAll(opVars);
        removals.forEach(arg_0 -> this.varDeps.removeAll(arg_0));
    }

    public void visit(OpJoin op) {
        Collection children = this.tree.getChildren((Object)op);
        this.processJoin(children);
    }

    public void visit(OpLeftJoin op) {
        Collection children = this.tree.getChildren((Object)op);
        this.processJoin(children);
        this.processExprs(op.getExprs());
    }

    public void visit(OpSequence op) {
        Collection children = this.tree.getChildren((Object)op);
        this.processJoin(children);
    }

    public void visit(OpFilter op) {
        this.processExprs(op.getExprs());
    }

    public void visit(OpGroup op) {
        List exprAggs = op.getAggregators();
        HashMultimap updates = HashMultimap.create();
        exprAggs.forEach(arg_0 -> this.lambda$visit$4((Multimap)updates, arg_0));
        updates.asMap().forEach((k, w) -> {
            this.nonUnique.addAll((Collection<Var>)w);
            this.varDeps.replaceValues(k, (Iterable)w);
        });
        VarExprList groupVars = op.getGroupVars();
        this.processExtend(groupVars);
    }

    public void visit(OpExtend op) {
        this.processExtend(op.getVarExprList());
    }

    public void visit(OpAssign op) {
        this.processExtend(op.getVarExprList());
    }

    public void visit(OpOrder op) {
        for (SortCondition sc : op.getConditions()) {
            this.processExpr(sc.getExpression());
        }
    }

    public void visit(OpDistinct op) {
        this.processDistinct();
    }

    public void visit(OpReduced op) {
        this.processDistinct();
    }

    private /* synthetic */ void lambda$visit$4(Multimap updates, ExprAggregator ea) {
        Var v = ea.getVar();
        ExprList el = ea.getAggregator().getExprList();
        if (el != null) {
            Set vars = ExprVars.getVarsMentioned((ExprList)el);
            Set<Var> origVars = MultimapUtils.getAll(this.varDeps, (Collection)vars);
            if (origVars.isEmpty()) {
                origVars = Collections.singleton(v);
            }
            updates.putAll((Object)v, origVars);
        }
    }

    private /* synthetic */ void lambda$processExtend$2(Multimap updates, Var v, Expr ex) {
        Set vars = ex == null ? Collections.singleton(v) : ExprVars.getVarsMentioned((Expr)ex);
        vars.forEach(w -> {
            Collection deps = this.varDeps.get(w);
            updates.putAll((Object)v, (Iterable)deps);
        });
    }
}

