/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.graph.index.jena.transform;

import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.commons.graph.index.jena.transform.OpTransformNormalizeUnaryOps;
import org.aksw.commons.jena.graph.GraphVar;
import org.aksw.commons.jena.jgrapht.LabeledEdge;
import org.aksw.commons.jena.jgrapht.LabeledEdgeImpl;
import org.aksw.jena_sparql_api.algebra.transform.TransformDistributeJoinOverUnion;
import org.aksw.jena_sparql_api.algebra.transform.TransformJoinToSequence;
import org.aksw.jena_sparql_api.algebra.transform.TransformMergeProject;
import org.aksw.jena_sparql_api.algebra.transform.TransformReplaceConstants;
import org.aksw.jena_sparql_api.algebra.transform.TransformUnionToDisjunction;
import org.aksw.jena_sparql_api.algebra.utils.AlgebraUtils;
import org.aksw.jena_sparql_api.algebra.utils.ExtendedQueryToGraphVisitor;
import org.aksw.jena_sparql_api.algebra.utils.OpExtConjunctiveQuery;
import org.aksw.jena_sparql_api.algebra.utils.OpUtils;
import org.aksw.jenax.arq.util.expr.DnfUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorImpl2;
import org.aksw.jenax.arq.util.var.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.optimize.TransformFilterPlacement;
import org.apache.jena.sparql.algebra.optimize.TransformMergeBGPs;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;
import org.jgrapht.Graph;
import org.jgrapht.alg.isomorphism.IsomorphicGraphMapping;
import org.jgrapht.alg.isomorphism.VF2SubgraphIsomorphismInspector;
import org.jgrapht.alg.isomorphism.VF2SubgraphMappingIterator;

public class QueryToGraph {
    public static Node unionMember = NodeFactory.createURI((String)"http://ex.org/unionMember");
    public static Node quadBlockMember = NodeFactory.createURI((String)"http://ex.org/quadBlockMember");
    public static Node filtered = NodeFactory.createURI((String)"http://ex.org/filtered");

    public static Op normalizeOpReplaceConstants(Op op) {
        op = TransformDistributeJoinOverUnion.transform(op);
        op = Transformer.transform((Transform)TransformUnionToDisjunction.fn, (Op)op);
        op = Transformer.transform((Transform)new TransformMergeBGPs(), (Op)op);
        op = Transformer.transform((Transform)TransformJoinToSequence.fn, (Op)op);
        op = Algebra.toQuadForm((Op)op);
        op = TransformReplaceConstants.transform(op);
        op = Transformer.transform((Transform)new TransformFilterPlacement(false), (Op)op);
        op = TransformMergeProject.transform(op);
        return op;
    }

    public static Op normalizeOp(Op baseOp, boolean normalizeUnaryOps) {
        Op op = QueryToGraph.normalizeOpReplaceConstants(baseOp);
        VarGeneratorImpl2 generatorCache = VarGeneratorImpl2.create();
        op = OpUtils.substitute(op, false, arg_0 -> QueryToGraph.lambda$normalizeOp$0((Generator)generatorCache, arg_0));
        if (normalizeUnaryOps) {
            op = Transformer.transform((Transform)new OpTransformNormalizeUnaryOps(), (Op)op);
        }
        return op;
    }

    public static org.apache.jena.graph.Graph queryToGraph(String queryStr) {
        Query query;
        try {
            query = QueryFactory.create((String)queryStr);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse: " + queryStr, e);
        }
        org.apache.jena.graph.Graph result = QueryToGraph.queryToGraph(query);
        return result;
    }

    public static org.apache.jena.graph.Graph queryToGraph(Query query) {
        Op op = Algebra.toQuadForm((Op)Algebra.compile((Query)query));
        Op nop = QueryToGraph.normalizeOp(op, false);
        org.apache.jena.graph.Graph result = QueryToGraph.queryToGraph(nop);
        return result;
    }

    public static org.apache.jena.graph.Graph queryToGraph(Op nop) {
        if (!(nop instanceof OpExtConjunctiveQuery)) {
            throw new RuntimeException("Not a conjunctive query - skipping");
        }
        OpExtConjunctiveQuery ocq = (OpExtConjunctiveQuery)nop;
        Supplier<Supplier> ssn = () -> {
            int[] x = new int[]{0};
            return () -> {
                int n = x[0];
                x[0] = n + 1;
                return NodeFactory.createBlankNode((String)("_" + n));
            };
        };
        ExtendedQueryToGraphVisitor q2g = new ExtendedQueryToGraphVisitor(ssn.get());
        q2g.visit(ocq);
        GraphVar result = q2g.getGraph();
        return result;
    }

    public static void addEdge(Graph<Node, LabeledEdge<Node, Node>> graph, Node edgeLabel, Node source, Node target) {
        graph.addVertex((Object)source);
        graph.addVertex((Object)target);
        graph.addEdge((Object)source, (Object)target, (Object)new LabeledEdgeImpl((Object)source, (Object)target, (Object)edgeLabel));
    }

    public static Node addQuad(Graph<Node, LabeledEdge<Node, Node>> graph, Quad quad) {
        Node quadNode = NodeFactory.createBlankNode();
        QueryToGraph.addEdge(graph, (Node)Vars.s, quad.getSubject(), quadNode);
        QueryToGraph.addEdge(graph, (Node)Vars.p, quadNode, quad.getPredicate());
        QueryToGraph.addEdge(graph, (Node)Vars.o, quadNode, quad.getObject());
        QueryToGraph.addEdge(graph, (Node)Vars.g, quadNode, quad.getGraph());
        return quadNode;
    }

    public static Node quadsToGraphNode(Graph<Node, LabeledEdge<Node, Node>> graph, Collection<Quad> quads) {
        Node quadBlockNode = NodeFactory.createBlankNode();
        for (Quad quad : quads) {
            Node quadNode = QueryToGraph.addQuad(graph, quad);
            QueryToGraph.addEdge(graph, quadBlockMember, quadBlockNode, quadNode);
        }
        return quadBlockNode;
    }

    public static void quadsToGraph(Graph<Node, LabeledEdge<Node, Node>> graph, Collection<Quad> quads) {
        for (Quad quad : quads) {
            QueryToGraph.addQuad(graph, quad);
        }
    }

    public static void equalExprsToGraph(Graph<Node, LabeledEdge<Node, Node>> graph, Collection<? extends Collection<? extends Expr>> dnf) {
        Set maps = DnfUtils.extractConstantConstraints(dnf);
        for (Map map : maps) {
            Node orNode = NodeFactory.createBlankNode();
            graph.addVertex((Object)orNode);
            for (Map.Entry e : map.entrySet()) {
                boolean createNodesForEqualities = true;
                if (createNodesForEqualities) {
                    Node equalsNode = NodeFactory.createBlankNode();
                    graph.addVertex((Object)equalsNode);
                    Var v = (Var)e.getKey();
                    Node c = ((NodeValue)e.getValue()).getNode();
                    graph.addVertex((Object)v);
                    graph.addVertex((Object)c);
                    graph.addEdge((Object)equalsNode, (Object)v, (Object)new LabeledEdgeImpl((Object)equalsNode, (Object)v, (Object)Vars.x));
                    graph.addEdge((Object)c, (Object)equalsNode, (Object)new LabeledEdgeImpl((Object)c, (Object)equalsNode, (Object)Vars.y));
                    graph.addEdge((Object)orNode, (Object)equalsNode, (Object)new LabeledEdgeImpl((Object)orNode, (Object)equalsNode, (Object)Vars.z));
                    continue;
                }
                Var v = (Var)e.getKey();
                Node c = ((NodeValue)e.getValue()).getNode();
                graph.addVertex((Object)v);
                graph.addVertex((Object)c);
                graph.addEdge((Object)orNode, (Object)v, (Object)new LabeledEdgeImpl((Object)orNode, (Object)v, (Object)Vars.x));
                graph.addEdge((Object)c, (Object)orNode, (Object)new LabeledEdgeImpl((Object)c, (Object)orNode, (Object)Vars.y));
            }
        }
    }

    public static Stream<Map<Var, Var>> match(Graph<Node, LabeledEdge<Node, Node>> a, Graph<Node, LabeledEdge<Node, Node>> b) {
        Comparator nodeCmp = (x, y) -> {
            int r = x.isVariable() && y.isVariable() || x.isBlank() && y.isBlank() ? 0 : x.toString().compareTo(y.toString());
            return r;
        };
        Comparator edgeCmp = (x, y) -> ((Node)x.getLabel()).toString().compareTo(((Node)y.getLabel()).toString());
        VF2SubgraphIsomorphismInspector inspector = new VF2SubgraphIsomorphismInspector(b, a, nodeCmp, edgeCmp, true);
        VF2SubgraphMappingIterator it = inspector.getMappings();
        Stream<Map<Var, Var>> result = Streams.stream((Iterator)it).map(x -> (IsomorphicGraphMapping)x).map(x -> {
            HashMap<Var, Var> varMap = new HashMap<Var, Var>();
            boolean r = true;
            for (Node node : b.vertexSet()) {
                Var s;
                if (!node.isVariable() || !x.hasVertexCorrespondence((Object)(s = (Var)node))) continue;
                Node fff = (Node)x.getVertexCorrespondence((Object)s, true);
                if (fff.isVariable()) {
                    varMap.put(s, (Var)fff);
                    continue;
                }
                r = false;
                break;
            }
            HashMap<Var, Var> s = r ? varMap : null;
            return s;
        }).filter(x -> x != null);
        return result;
    }

    private static /* synthetic */ Op lambda$normalizeOp$0(Generator generatorCache, Op o) {
        return AlgebraUtils.tryCreateCqfp(o, (Generator<Var>)generatorCache);
    }
}

