/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aksw.commons.collections.trees.Tree;
import org.aksw.jena_sparql_api.algebra.analysis.VarUsage;
import org.aksw.jena_sparql_api.algebra.utils.OpUtils;
import org.aksw.jenax.arq.util.expr.CnfUtils;
import org.aksw.jenax.arq.util.node.NodeTransformRenameMap;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVars;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;

public class TransformPushFiltersIntoBGP
extends TransformCopy {
    protected Tree<Op> tree;

    public static Op transform(Op op) {
        Tree<Op> tree = OpUtils.createTree(op);
        TransformPushFiltersIntoBGP transform = new TransformPushFiltersIntoBGP(tree);
        Op result = Transformer.transform((Transform)transform, (Op)op);
        return result;
    }

    public TransformPushFiltersIntoBGP(Tree<Op> tree) {
        this.tree = tree;
    }

    public static <I, O> Multimap<O, I> group(Iterable<I> items, Function<? super I, O> fn, Predicate<O> exclusions) {
        HashMultimap result = HashMultimap.create();
        for (I item : items) {
            O out = fn.apply(item);
            boolean exclude = exclusions != null && exclusions.test(out);
            if (exclude) continue;
            result.put(out, item);
        }
        return result;
    }

    public Op transform(OpFilter opFilter, Op subOp) {
        Op result;
        if (subOp instanceof OpQuadPattern || subOp instanceof OpQuadBlock || subOp instanceof OpBGP) {
            VarUsage varUsage = OpUtils.analyzeVarUsage(this.tree, (Op)opFilter);
            Set<Var> mandatoryVars = VarUsage.getMandatoryVars(varUsage);
            ExprList exprs = opFilter.getExprs();
            Set cnf = CnfUtils.toSetCnf((ExprList)exprs);
            Multimap<Map.Entry, Set> equalities = TransformPushFiltersIntoBGP.group(cnf, CnfUtils::extractEquality, Objects::isNull);
            Multimap<Var, Map.Entry> varToEntry = TransformPushFiltersIntoBGP.group(equalities.keySet(), e -> (Var)e.getKey(), null);
            Set consistentVars = varToEntry.asMap().entrySet().stream().filter(e -> ((Collection)e.getValue()).size() == 1).map(e -> (Var)e.getKey()).collect(Collectors.toSet());
            consistentVars.removeAll(mandatoryVars);
            Set consistentClauses = consistentVars.stream().flatMap(v -> varToEntry.get(v).stream()).flatMap(e -> equalities.get(e).stream()).collect(Collectors.toSet());
            Set residualClauses = cnf.stream().filter(clause -> !consistentClauses.contains(clause)).collect(Collectors.toSet());
            Set blockedVars = residualClauses.stream().flatMap(clause -> clause.stream().flatMap(expr -> ExprVars.getVarsMentioned((Expr)expr).stream())).collect(Collectors.toSet());
            consistentVars.removeAll(blockedVars);
            Set blockedClauses = blockedVars.stream().flatMap(v -> varToEntry.get(v).stream()).flatMap(e -> equalities.get(e).stream()).collect(Collectors.toSet());
            residualClauses.addAll(blockedClauses);
            Map<Var, Node> map = consistentVars.stream().collect(Collectors.toMap(v -> v, v -> (Node)((Map.Entry)varToEntry.get(v).iterator().next()).getValue()));
            Op newSubOp = map.isEmpty() ? subOp : NodeTransformLib.transform((NodeTransform)NodeTransformRenameMap.create(map), (Op)subOp);
            ExprList exprList = CnfUtils.toExprList(residualClauses);
            result = OpFilter.filterBy((ExprList)exprList, (Op)newSubOp);
        } else {
            result = super.transform(opFilter, subOp);
        }
        return result;
    }
}

