/*
 * Decompiled with CFR 0.152.
 */
package com.eccenca.access_control.triple_based.core;

import com.eccenca.access_control.triple_based.core.ElementTransformTripleBasedRewrite;
import com.eccenca.access_control.triple_based.core.GenericLayer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.collections.PolaritySet;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.syntax.VarExprListUtils;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.aksw.jenax.arq.util.var.VarGeneratorImpl2;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.api.Fragment3;
import org.aksw.jenax.sparql.fragment.impl.FragmentUtils;
import org.aksw.jenax.sparql.path.PathRewriter;
import org.aksw.jenax.sparql.path.PathUtils;
import org.aksw.jenax.util.backport.syntaxtransform.ElementTransformer;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathFactory;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformCleanGroupsOfOne;
import org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformApplyElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;

public class ElementTransformTripleRewrite
extends ElementTransformTripleBasedRewrite {
    protected int triplePatternCounter = 0;
    protected GenericLayer genericLayer;
    protected Generator<Var> varGen;
    protected transient PathRewriter pathRewriter;

    @Override
    public Element applyTriplePathTransform(TriplePath tp) {
        Path basePath = tp.getPath();
        Path effectivePath = this.pathRewriter.apply(basePath);
        Path foldPath = PathUtils.foldNulls((Path)effectivePath);
        Path finalPath = PathUtils.isNull((Path)foldPath) ? PathFactory.pathLink((Node)NodeUtils.nullUriNode) : foldPath;
        ElementPathBlock result = ElementUtils.createElementPath((Node)tp.getSubject(), (Path)finalPath, (Node)tp.getObject());
        if (PathUtils.isNull((Path)foldPath)) {
            result = ElementUtils.groupIfNeeded((Element[])new Element[]{result, new ElementFilter((Expr)NodeValue.FALSE)});
        }
        return result;
    }

    public static String prefixVarName(String prefix, String name) {
        Object result = Var.isAllocVarName((String)name) ? "." + prefix + name.substring(".".length()) : (Var.isBlankNodeVarName((String)name) ? "?" + prefix + name.substring("?".length()) : (Var.isRenamedVar((String)name) ? "/" + prefix + name.substring("/".length()) : name));
        return result;
    }

    public static Var prefixVar(String prefix, Var var) {
        Var result = Var.alloc((String)ElementTransformTripleRewrite.prefixVarName(prefix, var.getName()));
        return result;
    }

    @Override
    public Element applyTripleTransform(Triple t) {
        Fragment3 templateRelation = this.genericLayer.getRelation().toFragment3();
        int c = this.triplePatternCounter++;
        Map<Var, Var> instanceMap = templateRelation.getVarsMentioned().stream().collect(Collectors.toMap(v -> v, v -> ElementTransformTripleRewrite.prefixVar("i" + c + "_", v)));
        Fragment3 instanceRelation = templateRelation.applyNodeTransform((NodeTransform)new NodeTransformSubst(instanceMap)).toFragment3();
        Element result = ElementTransformTripleRewrite.applyTransform(t, instanceRelation, null, this.varGen);
        return result;
    }

    public ElementTransformTripleRewrite(GenericLayer genericLayer) {
        this(genericLayer, (Generator<Var>)VarGeneratorImpl2.create((String)"inj"));
    }

    public ElementTransformTripleRewrite(GenericLayer genericLayer, Generator<Var> varGen) {
        this.genericLayer = genericLayer;
        this.varGen = varGen;
    }

    public static Element applyTransform(Triple triple, Fragment3 filter, PolaritySet<Binding> valueSet, Generator<Var> varGen) {
        Node[] tripleNodes = TripleUtils.toArray((Triple)triple);
        Set tripleVars = NodeUtils.getVarsMentioned(Arrays.asList(tripleNodes));
        Set filterVars = filter.getVarsMentioned();
        HashSet blacklist = new HashSet(filterVars);
        blacklist.addAll(tripleVars);
        VarGeneratorBlacklist vg = VarGeneratorBlacklist.create(varGen, blacklist);
        ExprList filters = new ExprList();
        Var[] newTripleVars = new Var[3];
        for (int i = 0; i < tripleNodes.length; ++i) {
            Var tgt;
            Node tn = tripleNodes[i];
            if (tn.isVariable()) {
                tgt = (Var)tn;
            } else {
                tgt = (Var)vg.next();
                filters.add((Expr)new E_Equals((Expr)new ExprVar(tgt), (Expr)NodeValue.makeNode((Node)tn)));
            }
            newTripleVars[i] = tgt;
        }
        Element result = FragmentUtils.renameNodes((Fragment)filter, Arrays.asList(newTripleVars));
        if (!filters.isEmpty()) {
            result = ElementUtils.groupIfNeeded((Element[])new Element[]{result, new ElementFilter(ExprUtils.andifyBalanced((Iterable)filters))});
        }
        return result;
    }

    public static Query transform(Query query, GenericLayer conceptLayer, boolean cloneOnChange) {
        Query result;
        query.setResultVars();
        VarExprList velCopy = VarExprListUtils.copy((VarExprList)new VarExprList(), (VarExprList)query.getProject());
        Element oldQueryPattern = query.getQueryPattern();
        Element newQueryPattern = ElementTransformTripleRewrite.transform(oldQueryPattern, conceptLayer);
        if (oldQueryPattern == newQueryPattern) {
            result = query;
        } else {
            result = cloneOnChange ? query.cloneQuery() : query;
            result.setQueryResultStar(false);
            result.getProject().clear();
            result.getProject().addAll(velCopy);
            result.setQueryPattern(newQueryPattern);
        }
        return result;
    }

    public static Element transform(Element element, GenericLayer conceptLayer) {
        ElementTransformTripleRewrite elementTransform = new ElementTransformTripleRewrite(conceptLayer);
        Element result = ElementTransformer.transform((Element)element, (ElementTransform)elementTransform, (ExprTransform)new ExprTransformApplyElementTransform((ElementTransform)elementTransform));
        ElementTransformCleanGroupsOfOne t2 = new ElementTransformCleanGroupsOfOne();
        result = ElementTransformer.transform((Element)result, (ElementTransform)t2, (ExprTransform)new ExprTransformApplyElementTransform((ElementTransform)t2));
        return result;
    }
}

