/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.analysis;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.algebra.utils.ExprHolder;
import org.aksw.jena_sparql_api.algebra.utils.OpUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.E_LogicalAnd;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformSubstitute;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.ExprUtils;

public class DistinctExtendFilter2 {
    protected Map<Var, Expr> postDistinctVarDefs;
    protected boolean isDistinct;
    protected Map<Var, Expr> preDistinctVarDefs;
    protected ExprHolder filter;

    public Op toOp(Op result) {
        if (this.filter.getExpr().equals((Object)NodeValue.TRUE)) {
            result = OpFilter.filter((Expr)this.filter.getExpr(), (Op)result);
        }
        result = OpUtils.applyExtendProject(result, this.preDistinctVarDefs);
        if (this.postDistinctVarDefs != null) {
            result = OpDistinct.create((Op)result);
            result = OpUtils.applyExtendProject(result, this.postDistinctVarDefs);
        }
        return result;
    }

    public DistinctExtendFilter2(Map<Var, Expr> varToDef, boolean distinct, ExprHolder filter) {
        this.preDistinctVarDefs = varToDef;
        this.filter = filter;
    }

    public static DistinctExtendFilter2 create() {
        DistinctExtendFilter2 result = new DistinctExtendFilter2(null, false, ExprHolder.from((Expr)NodeValue.TRUE));
        return result;
    }

    public static Map<Var, Expr> createIdentityMap(Collection<Var> vars) {
        Map result = vars.stream().distinct().collect(Collectors.toMap(v -> v, v -> new ExprVar(v), (u, v) -> {
            throw new RuntimeException("duplicate");
        }, LinkedHashMap::new));
        return result;
    }

    public static DistinctExtendFilter2 create(Collection<Var> initialVars) {
        Map<Var, Expr> map = DistinctExtendFilter2.createIdentityMap(initialVars);
        DistinctExtendFilter2 result = new DistinctExtendFilter2(map, false, ExprHolder.from((Expr)NodeValue.TRUE));
        return result;
    }

    public DistinctExtendFilter2 applyProject(Collection<Var> projectVars) {
        boolean isValidRequest;
        Map<Var, Expr> varDefs;
        Map<Var, Expr> map = varDefs = this.isDistinct ? this.postDistinctVarDefs : this.preDistinctVarDefs;
        if (varDefs == null) {
            if (this.isDistinct) {
                varDefs = this.postDistinctVarDefs = new LinkedHashMap<Var, Expr>();
            } else {
                this.preDistinctVarDefs = new LinkedHashMap<Var, Expr>();
                varDefs = this.preDistinctVarDefs;
            }
            Map<Var, Expr> tmp = DistinctExtendFilter2.createIdentityMap(projectVars);
            varDefs.putAll(tmp);
        }
        if (!(isValidRequest = varDefs.keySet().containsAll(projectVars))) {
            throw new RuntimeException("Cannot project by non-available vars");
        }
        varDefs.keySet().retainAll(projectVars);
        return this;
    }

    public DistinctExtendFilter2 applyDistinct() {
        if (this.postDistinctVarDefs != null) {
            this.preDistinctVarDefs = DistinctExtendFilter2.expandDefs(this.postDistinctVarDefs, this.preDistinctVarDefs);
        }
        this.isDistinct = true;
        this.postDistinctVarDefs = null;
        return this;
    }

    public DistinctExtendFilter2 applyExtend(VarExprList extend) {
        Map map = extend.getExprs();
        this.applyExtend(map);
        return this;
    }

    public DistinctExtendFilter2 applyExtend(Map<Var, Expr> extend) {
        Map<Var, Expr> tmp;
        Map<Var, Expr> map = tmp = this.postDistinctVarDefs == null ? extend : DistinctExtendFilter2.expandDefs(extend, this.postDistinctVarDefs);
        if (tmp != null) {
            tmp = DistinctExtendFilter2.expandDefs(tmp, this.preDistinctVarDefs);
            if (this.postDistinctVarDefs == null) {
                this.preDistinctVarDefs.putAll(tmp);
            } else {
                this.postDistinctVarDefs.putAll(tmp);
            }
        }
        return this;
    }

    public DistinctExtendFilter2 applyFilter(ExprList contribExprs) {
        for (Expr expr : contribExprs) {
            this.applyFilter(expr);
        }
        return this;
    }

    public DistinctExtendFilter2 applyFilter(Expr contribExpr) {
        ExprHolder eh;
        Set mentionedVars = contribExpr.getVarsMentioned();
        Set<Var> availableVars = this.isDistinct ? (this.postDistinctVarDefs == null ? null : this.postDistinctVarDefs.keySet()) : (this.preDistinctVarDefs == null ? null : this.preDistinctVarDefs.keySet());
        Sets.SetView errVars = Sets.difference((Set)mentionedVars, availableVars);
        if (!errVars.isEmpty()) {
            throw new RuntimeException("Reference to unavailable vars: " + String.valueOf(errVars) + ", available: " + String.valueOf(availableVars));
        }
        Expr expandedExpr = this.expandExpr(contribExpr);
        Expr currentExpr = this.filter.getExpr();
        Expr expr = NodeValue.TRUE.equals((Object)currentExpr) ? expandedExpr : new E_LogicalAnd(currentExpr, expandedExpr);
        this.filter = eh = ExprHolder.from(expr);
        return this;
    }

    public static String toString(Map.Entry<Var, Expr> e) {
        Var v = e.getKey();
        Expr x = e.getValue();
        String result = x.isVariable() && x.asVar().equals((Object)v) ? String.valueOf(v) : "(" + String.valueOf(x) + " AS " + String.valueOf(v) + ")";
        return result;
    }

    public static String toString(Map<Var, Expr> varDefs) {
        String result = String.join((CharSequence)" ", varDefs.entrySet().stream().map(DistinctExtendFilter2::toString).collect(Collectors.toList()));
        return result;
    }

    public String toString() {
        Object result = "";
        if (this.postDistinctVarDefs != null) {
            result = (String)result + "SELECT " + DistinctExtendFilter2.toString(this.postDistinctVarDefs) + " {\n";
        }
        result = (String)result + "SELECT " + (this.postDistinctVarDefs != null ? "DISTINCT " : "") + DistinctExtendFilter2.toString(this.preDistinctVarDefs) + " {\n";
        result = (String)result + "FILTER(" + String.valueOf(this.filter.getExpr()) + ")\n";
        if (this.postDistinctVarDefs != null) {
            result = (String)result + "}\n";
        }
        return result;
    }

    public Expr expandExpr(Expr expr) {
        Expr result = this.postDistinctVarDefs != null ? DistinctExtendFilter2.expandExpr(expr, this.postDistinctVarDefs) : expr;
        result = DistinctExtendFilter2.expandExpr(expr, this.preDistinctVarDefs);
        return result;
    }

    public static Map<Var, Expr> expandDefs(Map<Var, Expr> src, Map<Var, Expr> varDefs) {
        ExprTransform exprTransform = DistinctExtendFilter2.createExprTransform(varDefs);
        Map result = src.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Expr expr = (Expr)e.getValue();
            Expr r = ExprTransformer.transform((ExprTransform)exprTransform, (Expr)expr);
            return r;
        }, (u, v) -> {
            throw new RuntimeException("duplicate");
        }, LinkedHashMap::new));
        return result;
    }

    public static ExprTransform createExprTransform(Map<Var, Expr> varDefs) {
        Map tmp = varDefs.entrySet().stream().collect(Collectors.toMap(e -> ((Var)e.getKey()).getName(), Map.Entry::getValue, (u, v) -> {
            throw new RuntimeException("duplicate");
        }, LinkedHashMap::new));
        ExprTransformSubstitute result = new ExprTransformSubstitute(tmp);
        return result;
    }

    public static Expr expandExpr(Expr expr, Map<Var, Expr> varDefs) {
        ExprTransform exprTransform = DistinctExtendFilter2.createExprTransform(varDefs);
        Expr result = ExprTransformer.transform((ExprTransform)exprTransform, (Expr)expr);
        return result;
    }

    public static void main(String[] args) {
        DistinctExtendFilter2 def = DistinctExtendFilter2.create(new LinkedHashSet<Var>(Arrays.asList(Vars.s, Vars.p, Vars.o)));
        def.applyExtend(Collections.singletonMap(Vars.s, ExprUtils.parse((String)"?p + ?o")));
        def.applyDistinct();
        def.applyFilter(ExprUtils.parse((String)"?s = ?p"));
        def.applyDistinct();
        def.applyDistinct();
        def.applyDistinct();
        System.out.println(def);
    }
}

