/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.graph.index.jena.transform;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Supplier;
import org.aksw.commons.graph.index.jena.transform.QueryToGraph;
import org.aksw.commons.graph.index.jena.transform.QueryToJenaGraph;
import org.aksw.commons.jena.graph.GraphVar;
import org.aksw.commons.jena.graph.GraphVarImpl;
import org.aksw.jenax.arq.util.expr.DnfUtils;
import org.aksw.jenax.arq.util.quad.QuadPatternUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.OpVisitorBase;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;

public class QueryToGraphVisitor
extends OpVisitorBase {
    protected Supplier<Node> nodeSupplier;
    protected BiMap<Var, Node> varToNode;
    protected BiMap<Quad, Node> quadToNode;
    protected GraphVar graph;
    protected BiMap<Node, Expr> nodeToExpr;
    protected Stack<Node> stack = new Stack();

    public QueryToGraphVisitor() {
        this((GraphVar)new GraphVarImpl(), () -> NodeFactory.createBlankNode());
    }

    public QueryToGraphVisitor(Supplier<Node> nodeSupplier) {
        this((GraphVar)new GraphVarImpl(), nodeSupplier);
    }

    public QueryToGraphVisitor(GraphVar graph, Supplier<Node> nodeSupplier) {
        this.graph = graph;
        this.nodeSupplier = nodeSupplier;
        this.varToNode = HashBiMap.create();
        this.nodeToExpr = HashBiMap.create();
        this.quadToNode = HashBiMap.create();
    }

    public BiMap<Var, Node> getVarToNode() {
        return this.varToNode;
    }

    public BiMap<Node, Var> getNodeToVar() {
        return this.varToNode.inverse();
    }

    public BiMap<Quad, Node> getQuadToNode() {
        return this.quadToNode;
    }

    public BiMap<Node, Quad> getNodeToQuad() {
        return this.quadToNode.inverse();
    }

    public BiMap<Node, Expr> getNodeToExpr() {
        return this.nodeToExpr;
    }

    public GraphVar getGraph() {
        return this.graph;
    }

    public Node getResult() {
        return (Node)this.stack.firstElement();
    }

    public void visit(OpDistinct op) {
        op.getSubOp().visit((OpVisitor)this);
    }

    public void visit(OpProject op) {
        op.getSubOp().visit((OpVisitor)this);
    }

    public void visit(OpFilter op) {
        Op subOp = op.getSubOp();
        subOp.visit((OpVisitor)this);
        Node subNode = this.stack.pop();
        ExprList exprs = op.getExprs();
        Set dnf = DnfUtils.toSetDnf((ExprList)exprs);
        QueryToJenaGraph.dnfToGraph((Graph)this.graph, this.nodeToExpr, dnf, this.nodeSupplier);
        Node result = this.nodeSupplier.get();
        QueryToJenaGraph.addEdge((Graph)this.graph, result, QueryToGraph.filtered, subNode);
        this.stack.push(result);
    }

    public void visit(OpQuadBlock op) {
        QuadPattern quadPattern = op.getPattern();
        List quads = quadPattern.getList();
        this.handleQuads(quads);
    }

    public void visit(OpBGP op) {
        List quads = QuadPatternUtils.toQuadPattern((BasicPattern)op.getPattern()).getList();
        this.handleQuads(quads);
    }

    public void visit(OpQuadPattern op) {
        List quads = op.getPattern().getList();
        this.handleQuads(quads);
    }

    public void handleQuads(List<Quad> quads) {
        Node result = QueryToJenaGraph.quadsToGraphNode((Graph)this.graph, this.quadToNode, quads, this.nodeSupplier);
        this.stack.push(result);
    }

    public void visit(OpDisjunction op) {
        Node result = this.nodeSupplier.get();
        List ops = op.getElements();
        for (Op member : ops) {
            member.visit((OpVisitor)this);
            Node memberNode = this.stack.pop();
            QueryToJenaGraph.addEdge((Graph)this.graph, result, QueryToGraph.unionMember, memberNode);
        }
        this.stack.push(result);
    }
}

