/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.utils;

import com.eccenca.access_control.triple_based.core.ElementTransformTripleRewrite;
import com.eccenca.access_control.triple_based.core.GenericLayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.jena_sparql_api.algebra.transform.TransformReplaceConstants;
import org.aksw.jena_sparql_api.algebra.utils.AlgebraUtils;
import org.aksw.jenax.arq.util.node.NodeTransformRenameMap;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.api.Fragment3;
import org.aksw.jenax.sparql.fragment.api.HasElement;
import org.aksw.jenax.sparql.fragment.impl.Fragment3Impl;
import org.aksw.jenax.sparql.fragment.impl.FragmentImpl;
import org.aksw.jenax.sparql.fragment.impl.FragmentUtils;
import org.aksw.jenax.sparql.fragment.impl.XExpr;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.optimize.Rewrite;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualPartitionedQuery {
    private static final Logger logger = LoggerFactory.getLogger(VirtualPartitionedQuery.class);

    public static Fragment3 unionTernary(Collection<? extends Fragment3> items) {
        Fragment tmp = VirtualPartitionedQuery.union(items, Arrays.asList(Vars.s, Vars.p, Vars.o));
        Fragment3 result = tmp.toFragment3();
        return result;
    }

    public static Fragment1 unionUnary(Collection<? extends Fragment1> relations) {
        Fragment tmp = VirtualPartitionedQuery.union(relations, Collections.singletonList(Vars.s));
        Fragment1 result = tmp.toFragment1();
        return result;
    }

    public static Fragment union(Collection<? extends Fragment> items, List<Var> proj) {
        List elements = items.stream().map(e -> FragmentUtils.rename((Fragment)e, (List)proj)).map(HasElement::getElement).collect(Collectors.toList());
        Element e2 = ElementUtils.unionIfNeeded(elements);
        FragmentImpl result = new FragmentImpl(e2, proj);
        return result;
    }

    public static Query rewrite(Collection<Fragment3> views, Query query) {
        Fragment3 tr = VirtualPartitionedQuery.unionTernary(views);
        GenericLayer layer = GenericLayer.create((Fragment)tr);
        Query raw = ElementTransformTripleRewrite.transform(query, layer, true);
        logger.debug("Query over View: Raw rewritten query:\n" + String.valueOf(raw));
        Query result = QueryUtils.rewrite((Query)raw, arg_0 -> ((Rewrite)AlgebraUtils.createDefaultRewriter()).rewrite(arg_0));
        logger.debug("Query over View: Final rewritten query:\n" + String.valueOf(result));
        return result;
    }

    public static Collection<Fragment3> toViews(Query query) {
        if (!query.isConstructType() || query.isConstructQuad()) {
            throw new RuntimeException("Construct query (without quads) expected");
        }
        Op op = Algebra.compile((Query)query);
        Set visibleVars = OpVars.visibleVars((Op)op);
        VarGeneratorBlacklist gen = VarGeneratorBlacklist.create((Collection)visibleVars);
        ArrayList<Fragment3> result = new ArrayList<Fragment3>();
        Template template = query.getConstructTemplate();
        Element pattern = query.getQueryPattern();
        for (Triple t : template.getTriples()) {
            Element newE;
            List nodes = TripleUtils.tripleToList((Triple)t);
            HashMap<Node, Var> nodeToVar = new HashMap<Node, Var>();
            Map<Node, Var> substs = TransformReplaceConstants.transform(nodeToVar, nodes, (Generator<Var>)gen);
            Triple newT = NodeTransformLib.transform((NodeTransform)NodeTransformRenameMap.create(substs), (Triple)t);
            if (substs.isEmpty()) {
                newE = pattern;
            } else {
                ElementGroup tgt = new ElementGroup();
                ElementUtils.copyElements((ElementGroup)tgt, (Element)pattern);
                for (Map.Entry<Node, Var> e : substs.entrySet()) {
                    tgt.addElement((Element)new ElementBind(e.getValue(), (Expr)NodeValue.makeNode((Node)e.getKey())));
                }
                newE = tgt;
            }
            Fragment3Impl tr = new Fragment3Impl(newE, (Var)newT.getSubject(), (Var)newT.getPredicate(), (Var)newT.getObject());
            result.add((Fragment3)tr);
        }
        return result;
    }

    static class GeneralizedStep {
        boolean isFwd;
        XExpr expr;

        GeneralizedStep() {
        }
    }
}

