/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.algebra.transform.TransformEvalTable;
import org.aksw.jenax.arq.util.binding.TableUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;

public class TransformFactorizeTableColumnsToExtend
extends TransformCopy {
    protected boolean preventEmptyTable = true;

    public Op transform(OpTable opTable) {
        OpTable result;
        Table table = opTable.getTable();
        Map<Var, Node> constants = TransformFactorizeTableColumnsToExtend.extractConstants(TableUtils.toResultSet((Table)table));
        LinkedHashSet tableVars = new LinkedHashSet(table.getVars());
        Set<Var> constantVars = constants.keySet();
        if (constantVars.containsAll(tableVars) && this.preventEmptyTable && !tableVars.isEmpty()) {
            constantVars.remove(tableVars.iterator().next());
        }
        if (constants.isEmpty()) {
            result = opTable;
        } else {
            VarExprList vel = new VarExprList();
            for (Map.Entry<Var, Node> e : constants.entrySet()) {
                vel.add(e.getKey(), (Expr)NodeValue.makeNode((Node)e.getValue()));
            }
            ArrayList remainingTableVars = new ArrayList(Sets.difference(tableVars, constantVars));
            OpTable newTable = TransformEvalTable.create().exec((Op)new OpProject((Op)opTable, remainingTableVars));
            result = OpExtend.extend((Op)newTable, (VarExprList)vel);
        }
        return result;
    }

    public static Map<Var, Node> extractConstants(ResultSet rs) {
        Set candVars = rs.getResultVars().stream().map(Var::alloc).collect(Collectors.toSet());
        HashMap<Var, Node> result = new HashMap<Var, Node>();
        block0: while (rs.hasNext()) {
            Binding b = rs.nextBinding();
            Iterator itVar = candVars.iterator();
            while (itVar.hasNext()) {
                Var v = (Var)itVar.next();
                Node n = b.get(v);
                if (result.containsKey(v)) {
                    Node prev = (Node)result.get(v);
                    if (Objects.equals(prev, n)) continue;
                    itVar.remove();
                    result.remove(v);
                    if (!candVars.isEmpty()) continue;
                    continue block0;
                }
                result.put(v, n);
            }
        }
        return result;
    }
}

