/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.graph.index.jena.transform;

import com.google.common.collect.BiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.aksw.jena_sparql_api.algebra.transform.ExprTransformVariableOrder;
import org.aksw.jenax.arq.util.expr.DnfUtils;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_StrContains;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.vocabulary.RDFS;

public class QueryToJenaGraph {
    public static Node unionMember = NodeFactory.createURI((String)"http://ex.org/unionMember");
    public static Node quadBlockMember = NodeFactory.createURI((String)"http://ex.org/quadBlockMember");
    public static Node filtered = NodeFactory.createURI((String)"http://ex.org/filtered");
    public static Node TP = NodeFactory.createURI((String)"http://ex.org/TP");
    public static final Node g = NodeFactory.createURI((String)"http://ex.org/g");
    public static final Node s = NodeFactory.createURI((String)"http://ex.org/s");
    public static final Node p = NodeFactory.createURI((String)"http://ex.org/p");
    public static final Node o = NodeFactory.createURI((String)"http://ex.org/o");
    public static final Node[] gspo = new Node[]{g, s, p, o};
    public static final Node argNode = NodeFactory.createURI((String)"arg://unordered");
    public static final Node cm = NodeFactory.createURI((String)"http://ex.org/cm");
    public static final Node dm = NodeFactory.createURI((String)"http://ex.org/dm");
    public static final Node ev = NodeFactory.createURI((String)"http://ex.org/ea");
    public static final Node ec = NodeFactory.createURI((String)"http://ex.org/ea");

    public static void addEdge(Graph graph, Node source, Node edgeLabel, Node target) {
        graph.add(Triple.create((Node)source, (Node)edgeLabel, (Node)target));
    }

    public static Node addQuad(Graph graph, Quad quad, Map<Quad, Node> quadToNode, Supplier<Node> nodeSupplier) {
        Node quadNode = quadToNode.get(quad);
        if (quadNode == null) {
            quadNode = nodeSupplier.get();
            quadToNode.put(quad, quadNode);
            Node gg = quad.getGraph();
            if (!Quad.defaultGraphIRI.equals((Object)gg) && !Quad.defaultGraphNodeGenerated.equals((Object)gg)) {
                QueryToJenaGraph.addEdge(graph, quadNode, g, quad.getGraph());
            }
            QueryToJenaGraph.addEdge(graph, quadNode, s, quad.getSubject());
            QueryToJenaGraph.addEdge(graph, quadNode, p, quad.getPredicate());
            QueryToJenaGraph.addEdge(graph, quadNode, o, quad.getObject());
        }
        return quadNode;
    }

    public static Node quadsToGraphNode(Graph graph, Map<Quad, Node> quadToNode, Collection<Quad> quads, Supplier<Node> nodeSupplier) {
        Node quadBlockNode = nodeSupplier.get();
        for (Quad quad : quads) {
            Node quadNode = QueryToJenaGraph.addQuad(graph, quad, quadToNode, nodeSupplier);
            QueryToJenaGraph.addEdge(graph, quadBlockNode, quadBlockMember, quadNode);
        }
        return quadBlockNode;
    }

    public static void quadsToGraph(Graph graph, Collection<Quad> quads, Map<Quad, Node> quadToNode, Supplier<Node> nodeSupplier) {
        for (Quad quad : quads) {
            QueryToJenaGraph.addQuad(graph, quad, quadToNode, nodeSupplier);
        }
    }

    public static Node exprToGraph(Graph graph, Map<Node, Expr> nodeToExpr, Expr expr, boolean isRootExpr, Supplier<Node> nodeSupplier) {
        Node result;
        if (expr.isConstant()) {
            result = expr.getConstant().asNode();
        } else if (expr.isFunction()) {
            E_StrContains e;
            result = nodeSupplier.get();
            nodeToExpr.put(result, expr);
            boolean isCommutative = ExprTransformVariableOrder.isCommutative(expr);
            ExprFunction ef = expr.getFunction();
            String fnId = ExprUtils.getFunctionId((ExprFunction)ef);
            graph.add(Triple.create((Node)result, (Node)RDFS.label.asNode(), (Node)NodeFactory.createLiteral((String)fnId)));
            List args = ef.getArgs();
            int n = args.size();
            if (isRootExpr && expr instanceof E_StrContains && (e = (E_StrContains)expr).getArg2().isConstant()) {
                n = 1;
            }
            for (int i = 0; i < n; ++i) {
                Expr arg = (Expr)args.get(i);
                Node argNode = QueryToJenaGraph.exprToGraph(graph, nodeToExpr, arg, false, nodeSupplier);
                Node p = isCommutative ? NodeFactory.createURI((String)"arg://any") : NodeFactory.createURI((String)("arg://" + i));
                graph.add(Triple.create((Node)result, (Node)p, (Node)argNode));
            }
        } else if (expr.isVariable()) {
            result = expr.asVar();
        } else {
            throw new RuntimeException("should not happen");
        }
        return result;
    }

    public static void dnfToGraph(Graph graph, BiMap<Node, Expr> nodeToExpr, Collection<? extends Collection<? extends Expr>> dnf, Supplier<Node> nodeSupplier) {
        Node orNode = nodeSupplier.get();
        for (Collection<? extends Expr> collection : dnf) {
            Node andNode = nodeSupplier.get();
            QueryToJenaGraph.addEdge(graph, orNode, dm, andNode);
            QueryToJenaGraph.clauseToGraph(andNode, graph, nodeToExpr, collection, nodeSupplier);
        }
    }

    public static void clauseToGraph(Node andNode, Graph graph, BiMap<Node, Expr> nodeToExpr, Collection<? extends Expr> clause, Supplier<Node> nodeSupplier) {
        for (Expr expr : clause) {
            Node eNode = (Node)nodeToExpr.inverse().get((Object)expr);
            if (eNode == null) {
                eNode = QueryToJenaGraph.exprToGraph(graph, nodeToExpr, expr, true, nodeSupplier);
            }
            if (andNode == null) continue;
            QueryToJenaGraph.addEdge(graph, andNode, cm, eNode);
        }
    }

    public static void equalExprsToGraphOld(Graph graph, Collection<? extends Collection<? extends Expr>> dnf, Supplier<Node> nodeSupplier, Map<Var, Node> varToNode) {
        Set maps = DnfUtils.extractConstantConstraints(dnf);
        for (Map map : maps) {
            Node orNode = nodeSupplier.get();
            for (Map.Entry e : map.entrySet()) {
                boolean createNodesForEqualities = true;
                if (createNodesForEqualities) {
                    Node equalsNode = nodeSupplier.get();
                    Var v = (Var)e.getKey();
                    Node c = ((NodeValue)e.getValue()).getNode();
                    QueryToJenaGraph.addEdge(graph, equalsNode, ev, (Node)v);
                    QueryToJenaGraph.addEdge(graph, c, ec, equalsNode);
                    QueryToJenaGraph.addEdge(graph, orNode, dm, equalsNode);
                    continue;
                }
                Var v = (Var)e.getKey();
                Node c = ((NodeValue)e.getValue()).getNode();
                QueryToJenaGraph.addEdge(graph, orNode, (Node)Vars.x, (Node)v);
                QueryToJenaGraph.addEdge(graph, c, (Node)Vars.y, orNode);
            }
        }
    }
}

