/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.aggregation;

import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.IntStream;
import org.aksw.jenax.arq.aggregation.BestLiteralConfig;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.function.FunctionEnv;

public class AccBestLiteral
implements Accumulator {
    protected BestLiteralConfig bestLiteralConfig;
    protected Node bestMatchNode;
    protected int[] bestMatchScore;

    public AccBestLiteral(BestLiteralConfig bestLiteralConfig) {
        this.bestLiteralConfig = bestLiteralConfig;
        this.bestMatchNode = null;
        this.bestMatchScore = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};
    }

    public void accumulate(Binding binding, FunctionEnv functionEnv) {
        boolean isBetterMatch;
        int langScore;
        Node subject = binding.get(this.bestLiteralConfig.getSubjectVar());
        Node property = binding.get(this.bestLiteralConfig.getPredicateVar());
        Node label = binding.get(this.bestLiteralConfig.getObjectVar());
        List<Node> predicates = this.bestLiteralConfig.getPredicates();
        List<String> langs = this.bestLiteralConfig.getLangs();
        if (this.bestMatchNode == null) {
            this.bestMatchNode = subject;
        }
        String candidateLang = NodeUtils.getLang((Node)label);
        int propertyScore = predicates == null ? 0 : predicates.indexOf(property);
        int[] score = new int[]{propertyScore, langScore = langs == null ? 0 : langs.indexOf(candidateLang)};
        boolean allNonNegative = IntStream.of(score).allMatch(item -> item >= 0);
        if (allNonNegative && (isBetterMatch = AccBestLiteral.compareIterators(IntStream.of(score).iterator(), IntStream.of(this.bestMatchScore).iterator(), (x, y) -> x < y))) {
            this.bestMatchScore = score;
            this.bestMatchNode = label;
        }
    }

    public NodeValue getValue() {
        return this.bestMatchNode == null ? null : NodeValue.makeNode((Node)this.bestMatchNode);
    }

    public static <T> boolean compareIterators(Iterator<T> as, Iterator<T> bs, BiPredicate<T, T> op) {
        boolean result = false;
        while (as.hasNext() && bs.hasNext()) {
            T b;
            T a = as.next();
            if (op.test(a, b = bs.next())) {
                if (op.test(b, a)) continue;
                result = true;
                break;
            }
            if (!op.test(b, a)) continue;
            result = false;
            break;
        }
        return result;
    }
}

