/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.aggregation;

import java.util.function.Predicate;
import org.aksw.commons.collector.domain.Accumulator;

public class AccCondition<B, E, V>
implements Accumulator<B, E, V> {
    protected Predicate<B> predicate;
    protected Accumulator<B, E, V> subAcc;

    public AccCondition(Predicate<B> predicate, Accumulator<B, E, V> subAcc) {
        this.predicate = predicate;
        this.subAcc = subAcc;
    }

    public void accumulate(B binding, E env) {
        boolean accept = this.predicate.test(binding);
        if (accept) {
            this.subAcc.accumulate(binding);
        }
    }

    public V getValue() {
        Object result = this.subAcc.getValue();
        return (V)result;
    }

    public static <B, E, V> Accumulator<B, E, V> create(Predicate<B> predicate, Accumulator<B, E, V> subAcc) {
        AccCondition<B, E, V> result = new AccCondition<B, E, V>(predicate, subAcc);
        return result;
    }
}

