/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.aggregation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.aksw.jenax.arq.aggregation.LiteralPreference;
import org.aksw.jenax.arq.util.var.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.sparql.core.Var;

public class BestLiteralConfig {
    protected LiteralPreference literalPreference;
    protected Var subjectVar;
    protected Var predicateVar;
    protected Var objectVar;

    public BestLiteralConfig(LiteralPreference literalPreference) {
        this(literalPreference, Vars.s, Vars.p, Vars.o);
    }

    public BestLiteralConfig(LiteralPreference literalPreference, Var subjectVar, Var predicateVar, Var objectVar) {
        this.literalPreference = literalPreference;
        this.subjectVar = subjectVar;
        this.predicateVar = predicateVar;
        this.objectVar = objectVar;
    }

    public LiteralPreference getLiteralPreference() {
        return this.literalPreference;
    }

    public Var getSubjectVar() {
        return this.subjectVar;
    }

    public Var getPredicateVar() {
        return this.predicateVar;
    }

    public Var getObjectVar() {
        return this.objectVar;
    }

    public List<String> getLangs() {
        List<String> result = this.literalPreference.getLangs();
        return result;
    }

    public List<Node> getPredicates() {
        List<Node> result = this.literalPreference.getPredicates();
        return result;
    }

    public static BestLiteralConfig fromProperty(Property property) {
        BestLiteralConfig result = new BestLiteralConfig(new LiteralPreference(null, Collections.singletonList(property.asNode()), false));
        return result;
    }

    public String toString() {
        String result = Arrays.asList("BestLabelConfig", this.getLangs(), this.getPredicates(), this.getSubjectVar(), this.getPredicateVar(), this.getObjectVar()).stream().map(Objects::toString).collect(Collectors.joining(", "));
        return result;
    }
}

