/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.aggregation;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.Aggregator;

public class Aggregators {
    public static <T, E, C extends Collection<T>> Collector<T, Accumulator<T, E, C>, C> createCollector(Aggregator<T, E, C> aggregator) {
        Collector<Object, Accumulator, Collection> result = Collector.of(() -> aggregator.createAccumulator(), Accumulator::accumulate, (needle, haystack) -> Aggregators.combineAccumulators(needle, haystack, x -> x, x -> x), Accumulator::getValue, new Collector.Characteristics[0]);
        return result;
    }

    public static <T, E, C extends Collection<T>> Collector<T, Accumulator<T, E, C>, Accumulator<T, E, C>> createCollectorRaw(Aggregator<T, E, C> aggregator, UnaryOperator<Accumulator<T, E, C>> accumulatorCloner) {
        Collector<Object, Accumulator, Accumulator> result = Collector.of(() -> aggregator.createAccumulator(), Accumulator::accumulate, (needle, haystack) -> Aggregators.combineAccumulators(needle, haystack, accumulatorCloner, x -> x), new Collector.Characteristics[0]);
        return result;
    }

    public static <T, E, V, C extends Collection<V>> Collector<T, Accumulator<T, E, C>, Accumulator<T, E, C>> createCollectorRaw(Aggregator<T, E, C> aggregator, Function<? super V, ? extends T> valueToItem, UnaryOperator<Accumulator<T, E, C>> accumulatorCloner) {
        Collector<Object, Accumulator, Accumulator> result = Collector.of(() -> aggregator.createAccumulator(), Accumulator::accumulate, (needle, haystack) -> Aggregators.combineAccumulators(needle, haystack, accumulatorCloner, valueToItem), new Collector.Characteristics[0]);
        return result;
    }

    public static <T, E, V, C extends Collection<V>> Accumulator<T, E, C> combineAccumulators(Accumulator<T, E, C> needle, Accumulator<T, E, C> haystack, UnaryOperator<Accumulator<T, E, C>> accumulatorCloner, Function<? super V, ? extends T> valueToItem) {
        if (((Collection)needle.getValue()).size() > ((Collection)haystack.getValue()).size()) {
            Accumulator<T, E, C> tmp = needle;
            needle = haystack;
            haystack = tmp;
        }
        Accumulator result = (Accumulator)accumulatorCloner.apply(haystack);
        for (Object value : (Collection)needle.getValue()) {
            T reductionItem = valueToItem.apply(value);
            result.accumulate(reductionItem);
        }
        return result;
    }
}

