/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.aggregation;

import java.util.Map;
import java.util.function.Function;
import org.aksw.commons.collector.domain.Accumulator;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;

public class AccComputeBinding<B, E, T>
implements Accumulator<B, E, T> {
    protected Map<Var, Function<B, Node>> varToNodeFn;
    protected Accumulator<Binding, E, T> delegate;

    public AccComputeBinding(Map<Var, Function<B, Node>> varToNodeFn, Accumulator<Binding, E, T> delegate) {
        this.varToNodeFn = varToNodeFn;
        this.delegate = delegate;
    }

    public void accumulate(B input, E env) {
        BindingBuilder builder = BindingBuilder.create();
        this.varToNodeFn.forEach((key, value) -> {
            Node node = (Node)value.apply(input);
            builder.add(key, node);
        });
        this.delegate.accumulate((Object)builder.build(), env);
    }

    public T getValue() {
        Object result = this.delegate.getValue();
        return (T)result;
    }
}

