/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.aggregation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aksw.jenax.arq.aggregation.Acc;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.modify.TemplateLib;
import org.apache.jena.sparql.syntax.Template;

public class AccSinkTriples<T extends Sink<Triple>>
implements Acc<T> {
    protected T sink;
    protected Template template;
    protected Node reverse;
    protected Map<Node, Node> bNodeMap = new HashMap<Node, Node>();

    public AccSinkTriples(T sink, Template template) {
        this(sink, template, NodeValue.FALSE.asNode());
    }

    public AccSinkTriples(T sink, Template template, Node reverse) {
        this.sink = sink;
        this.template = template;
        this.reverse = reverse;
    }

    public static boolean isTrue(Object o) {
        boolean result = Boolean.TRUE.equals(o) || o instanceof Number && ((Number)o).intValue() == 1;
        return result;
    }

    public void accumulate(Binding binding, FunctionEnv env) {
        Node node = this.reverse.isVariable() ? binding.get((Var)this.reverse) : this.reverse;
        boolean doReverse = node.isLiteral() ? AccSinkTriples.isTrue(node.getLiteralValue()) : false;
        Iterator it = TemplateLib.calcTriples((List)this.template.getTriples(), Collections.singleton(binding).iterator());
        while (it.hasNext()) {
            Triple triple = (Triple)it.next();
            if (doReverse) {
                triple = TripleUtils.swap((Triple)triple);
            }
            this.sink.send((Object)triple);
        }
    }

    public T getValue() {
        return this.sink;
    }
}

