/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.aggregation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.Aggregator;

public class AccMultiplexDynamic<B, E, K, V, W, C extends Aggregator<V, E, W>>
implements Accumulator<B, E, Map<K, W>> {
    protected Function<? super B, ? extends Iterator<? extends K>> keyMapper;
    protected BiFunction<? super B, ? super K, ? extends V> valueMapper;
    protected C subAgg;
    protected Map<K, Accumulator<V, E, W>> state = new HashMap<K, Accumulator<V, E, W>>();

    public AccMultiplexDynamic(Function<? super B, ? extends Iterator<? extends K>> keyMapper, BiFunction<? super B, ? super K, ? extends V> valueMapper, C subAgg) {
        this.keyMapper = keyMapper;
        this.valueMapper = valueMapper;
        this.subAgg = subAgg;
    }

    public void accumulate(B binding, E env) {
        Iterator<K> ks = this.keyMapper.apply(binding);
        while (ks.hasNext()) {
            K k = ks.next();
            V v = this.valueMapper.apply(binding, k);
            Accumulator subAcc = this.state.get(k);
            if (subAcc == null) {
                subAcc = this.subAgg.createAccumulator();
                this.state.put(k, subAcc);
            }
            subAcc.accumulate(v, env);
        }
    }

    public Map<K, W> getValue() {
        HashMap<K, Object> result = new HashMap<K, Object>();
        for (Map.Entry<K, Accumulator<V, E, W>> entry : this.state.entrySet()) {
            K k = entry.getKey();
            Object v = entry.getValue().getValue();
            result.put(k, v);
        }
        return result;
    }

    public static <B, E, K, V, W, C extends Aggregator<V, E, W>> AccMultiplexDynamic<B, E, K, V, W, C> create(Function<? super B, ? extends Iterator<? extends K>> keyMapper, BiFunction<? super B, ? super K, ? extends V> valueMapper, C subAgg) {
        AccMultiplexDynamic<? super B, E, ? super K, ? extends V, W, C> result = new AccMultiplexDynamic<B, E, K, V, W, C>(keyMapper, valueMapper, subAgg);
        return result;
    }
}

