/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.aggregation;

import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.aksw.commons.collector.domain.Aggregator;
import org.aksw.jenax.arq.aggregation.AccBindingTransform;
import org.aksw.jenax.arq.aggregation.AccCondition;
import org.aksw.jenax.arq.aggregation.AccMultiplexDynamic;
import org.aksw.jenax.arq.aggregation.AggMap2;
import org.aksw.jenax.arq.aggregation.AggTransform2;

public class AggregatorBuilder<B, E, T> {
    protected Aggregator<B, E, T> state;

    public AggregatorBuilder(Aggregator<B, E, T> state) {
        this.state = state;
    }

    public Aggregator<B, E, T> get() {
        return this.state;
    }

    public <K> AggregatorBuilder<B, E, Map<K, T>> wrapWithMap(Function<B, K> bindingToKey) {
        AggMap2 agg = AggMap2.create(bindingToKey, this.state);
        return new AggregatorBuilder<B, E, T>(agg);
    }

    public <X, K, V> AggregatorBuilder<X, E, Map<K, T>> wrapWithMultiplexDynamic(Function<? super X, ? extends Iterator<? extends K>> keyMapper, BiFunction<? super X, ? super K, ? extends B> valueMapper) {
        Aggregator local = this.state;
        Aggregator agg = () -> AccMultiplexDynamic.create(keyMapper, valueMapper, local);
        return new AggregatorBuilder<B, E, T>(agg);
    }

    public <O> AggregatorBuilder<B, E, O> wrapWithTransform(Function<? super T, O> transform) {
        AggTransform2 agg = AggTransform2.create(this.state, transform);
        return new AggregatorBuilder<B, E, T>(agg);
    }

    public AggregatorBuilder<B, E, T> wrapWithCondition(Predicate<B> predicate) {
        Aggregator local = this.state;
        Aggregator agg = () -> AccCondition.create(predicate, local.createAccumulator());
        return new AggregatorBuilder<B, E, T>(agg);
    }

    public <U> AggregatorBuilder<U, E, T> wrapWithBindingTransform(Function<? super U, B> transform) {
        Aggregator local = this.state;
        Aggregator agg = () -> AccBindingTransform.create(transform, local.createAccumulator());
        return new AggregatorBuilder<B, E, T>(agg);
    }

    public static <B, E, T> AggregatorBuilder<B, E, T> from(Aggregator<B, E, T> agg) {
        return new AggregatorBuilder<B, E, T>(agg);
    }
}

