/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.aggregation;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.Aggregator;

public class AccMap2<B, E, K, V, C extends Aggregator<B, E, V>>
implements Accumulator<B, E, Map<K, V>> {
    protected BiFunction<B, Long, K> mapper;
    protected C subAgg;
    protected Map<K, Accumulator<B, E, V>> state = new HashMap<K, Accumulator<B, E, V>>();

    public AccMap2(Function<B, K> mapper, C subAgg) {
        this((B binding, Long rowNum) -> mapper.apply(binding), subAgg);
    }

    public AccMap2(BiFunction<B, Long, K> mapper, C subAgg) {
        this.mapper = mapper;
        this.subAgg = subAgg;
    }

    public void accumulate(B binding, E env) {
        K k = this.mapper.apply(binding, -1L);
        Accumulator subAcc = this.state.get(k);
        if (subAcc == null) {
            subAcc = this.subAgg.createAccumulator();
            this.state.put(k, subAcc);
        }
        subAcc.accumulate(binding, env);
    }

    public Map<K, V> getValue() {
        HashMap<K, Object> result = new HashMap<K, Object>();
        for (Map.Entry<K, Accumulator<B, E, V>> entry : this.state.entrySet()) {
            K k = entry.getKey();
            Object v = entry.getValue().getValue();
            result.put(k, v);
        }
        return result;
    }

    public static <B, E, K, V, C extends Aggregator<B, E, V>> AccMap2<B, E, K, V, C> create(Function<B, K> mapper, C subAgg) {
        BiFunction<Object, Long, Object> fn = (binding, rowNum) -> mapper.apply(binding);
        AccMap2<Object, E, Object, V, C> result = new AccMap2<Object, E, Object, V, C>(fn, subAgg);
        return result;
    }

    public static <B, E, K, V, C extends Aggregator<B, E, V>> AccMap2<B, E, K, V, C> create(BiFunction<B, Long, K> mapper, C subAgg) {
        AccMap2<B, E, K, V, C> result = new AccMap2<B, E, K, V, C>(mapper, subAgg);
        return result;
    }
}

