/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.aggregation;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.aksw.commons.collector.domain.Accumulator;

public class AccStaticMultiplex<B, E, K, U, V>
implements Accumulator<B, E, Map<K, V>> {
    protected BiFunction<B, K, ? extends U> childBinding;
    protected Map<K, Accumulator<U, E, V>> keyToSubAcc;

    public AccStaticMultiplex(BiFunction<B, K, ? extends U> childBinding, Map<K, Accumulator<U, E, V>> keyToSubAcc) {
        this.childBinding = childBinding;
        this.keyToSubAcc = keyToSubAcc;
    }

    public void accumulate(B binding, E env) {
        for (Map.Entry<K, Accumulator<U, E, V>> e : this.keyToSubAcc.entrySet()) {
            K k = e.getKey();
            Accumulator<U, E, V> subAcc = e.getValue();
            U u = this.childBinding.apply(binding, k);
            subAcc.accumulate(u);
        }
    }

    public Map<K, V> getValue() {
        HashMap<K, Object> result = new HashMap<K, Object>(this.keyToSubAcc.size());
        for (Map.Entry<K, Accumulator<U, E, V>> e : this.keyToSubAcc.entrySet()) {
            K k = e.getKey();
            Accumulator<U, E, V> subAcc = e.getValue();
            Object v = subAcc.getValue();
            result.put(k, v);
        }
        return result;
    }

    public static <B, E, K, U, V> Accumulator<B, E, Map<K, V>> create(BiFunction<B, K, ? extends U> childBinding, Map<K, Accumulator<U, E, V>> keyToSubAcc) {
        AccStaticMultiplex<B, E, K, ? extends U, V> result = new AccStaticMultiplex<B, E, K, U, V>(childBinding, keyToSubAcc);
        return result;
    }
}

