/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.aggregation;

import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.jenax.arq.aggregation.Agg;
import org.aksw.jenax.arq.aggregation.AggLiteral;
import org.aksw.jenax.arq.aggregation.AggTransform;
import org.aksw.jenax.arq.aggregation.BindingMapper;
import org.aksw.jenax.arq.aggregation.BindingMapperExpr;
import org.aksw.jenax.arq.aggregation.FunctionNodeToObject;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.util.ExprUtils;

public class AggUtils {
    public static <T> T accumulate(Agg<T> agg, ResultSet rs) {
        Accumulator acc = agg.createAccumulator();
        while (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            acc.accumulate((Object)binding);
        }
        Object result = acc.getValue();
        return (T)result;
    }

    public static BindingMapper<Node> mapper(String exprStr) {
        Expr expr = ExprUtils.parse((String)exprStr);
        BindingMapperExpr result = new BindingMapperExpr(expr);
        return result;
    }

    public static Agg<Node> literalNode(String exprStr) {
        BindingMapper<Node> m = AggUtils.mapper(exprStr);
        AggLiteral<Node> result = new AggLiteral<Node>(m);
        return result;
    }

    public static Agg<Object> literal(String exprStr) {
        BindingMapper<Node> m = AggUtils.mapper(exprStr);
        AggLiteral<Node> tmp = new AggLiteral<Node>(m);
        AggTransform<Node, Object> result = AggTransform.create(tmp, FunctionNodeToObject.fn);
        return result;
    }

    public static Agg<Node> literalNode(Expr expr) {
        BindingMapperExpr m = new BindingMapperExpr(expr);
        AggLiteral<Node> result = new AggLiteral<Node>(m);
        return result;
    }
}

