/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.aggregation;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.aksw.commons.collections.SetUtils;
import org.aksw.jenax.arq.aggregation.AccGraph;
import org.aksw.jenax.arq.aggregation.Agg;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.Template;

public class AggGraph
implements Agg<Graph> {
    protected Template template;
    protected Node reverse;

    public AggGraph(Template template) {
        this(template, NodeValue.FALSE.asNode());
    }

    public AggGraph(Template template, Node reverse) {
        this.template = template;
        this.reverse = reverse;
    }

    @Override
    public AccGraph createAccumulator() {
        AccGraph result = new AccGraph(this.template, this.reverse);
        return result;
    }

    @Override
    public Set<Var> getDeclaredVars() {
        BasicPattern bgp = this.template.getBGP();
        Set result = SetUtils.asSet((Iterable)PatternVars.vars((Element)new ElementTriplesBlock(bgp)));
        if (this.reverse.isVariable()) {
            result = Sets.union(Collections.singleton((Var)this.reverse), (Set)result);
        }
        return result;
    }

    public static AggGraph create(Template template) {
        AggGraph result = new AggGraph(template);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.template == null ? 0 : this.template.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggGraph other = (AggGraph)obj;
        return !(this.template == null ? other.template != null : !this.template.equals(other.template));
    }

    public String toString() {
        return "AggGraph [template=" + String.valueOf(this.template) + "]";
    }
}

