/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.aggregation;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.modify.TemplateLib;
import org.apache.jena.sparql.syntax.Template;

public class AccGraph2 {
    protected Graph graph;
    protected Template template;
    protected Map<Node, Node> bnodeMap;

    public AccGraph2(Template template) {
        this(template, GraphFactory.createDefaultGraph(), new HashMap<Node, Node>());
    }

    public AccGraph2(Template template, Graph graph, Map<Node, Node> bnodeMap) {
        this.template = Objects.requireNonNull(template);
        this.graph = Objects.requireNonNull(graph);
        this.bnodeMap = bnodeMap;
    }

    public void accumulate(Binding binding) {
        for (Triple t : this.template.getTriples()) {
            Triple newT = TemplateLib.subst((Triple)t, (Binding)binding, this.bnodeMap);
            if (!newT.isConcrete()) continue;
            this.graph.add(newT);
        }
    }

    public Map<Node, Node> getBnodeMap() {
        return this.bnodeMap;
    }

    public Graph getValue() {
        return this.graph;
    }
}

