package org.aksw.jenax.annotation.reprogen;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Define the IRI for linking a map entry to its value.
 * Using this predicate implies the map mode where entries are
 * represented by dedicated resources.
 *
 * @author raven
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD, ElementType.FIELD})
public @interface ValueIri {
    String value() default "";
}
