/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.schema_mapping;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.jenax.arq.decisiontree.api.DecisionTreeSparqlExpr;
import org.aksw.jenax.arq.schema_mapping.ExprRewrite;
import org.aksw.jenax.arq.schema_mapping.FieldMapping;
import org.aksw.jenax.arq.schema_mapping.FieldMappingImpl;
import org.aksw.jenax.arq.schema_mapping.SchemaMapping;
import org.aksw.jenax.arq.schema_mapping.SchemaMappingImpl;
import org.aksw.jenax.arq.schema_mapping.TypePromoter;
import org.aksw.jenax.arq.util.expr.E_SerializableIdentity;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Datatype;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_Function;
import org.apache.jena.sparql.expr.E_IsBlank;
import org.apache.jena.sparql.expr.E_IsIRI;
import org.apache.jena.sparql.expr.E_Lang;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.util.SplitIRI;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;

public class SchemaMapperImpl {
    protected Set<Var> sourceVars;
    protected Function<? super Var, ? extends Set<String>> sourceVarToDatatypes;
    protected Function<? super Var, ? extends Number> sourceVarToNulls;
    protected Function<String, String> typeRemap;
    protected BiFunction<String, String, ? extends ExprRewrite> typeConversionSupplier;
    protected Function<? super Var, String> varToFallbackDatatype;
    protected TypePromoter typePromotionStrategy;

    public SchemaMapperImpl setSourceVars(Set<Var> sourceVars) {
        this.sourceVars = sourceVars;
        return this;
    }

    public Set<Var> getSourceVars() {
        return this.sourceVars;
    }

    public SchemaMapperImpl setSourceVarToDatatypes(Function<? super Var, ? extends Set<String>> sourceVarToDatatypes) {
        this.sourceVarToDatatypes = sourceVarToDatatypes;
        return this;
    }

    public SchemaMapperImpl setSourceVarToNulls(Function<? super Var, ? extends Number> sourceVarToNulls) {
        this.sourceVarToNulls = sourceVarToNulls;
        return this;
    }

    public SchemaMapperImpl setVarToFallbackDatatype(Function<? super Var, String> varToFallbackDatatype) {
        this.varToFallbackDatatype = varToFallbackDatatype;
        return this;
    }

    public SchemaMapperImpl setVarToFallbackDatatype(String datatype) {
        return this.setVarToFallbackDatatype((? super Var v) -> datatype);
    }

    public SchemaMapperImpl setVarToFallbackDatatypeToString() {
        return this.setVarToFallbackDatatype("http://www.w3.org/2001/XMLSchema#string");
    }

    public Function<String, String> getTypeRemap() {
        return this.typeRemap;
    }

    public SchemaMapperImpl setTypeRemap(Function<String, String> typeRemap) {
        this.typeRemap = typeRemap;
        return this;
    }

    public BiFunction<String, String, ? extends ExprRewrite> getTypeConversionSupplier() {
        return this.typeConversionSupplier;
    }

    public SchemaMapperImpl setTypeConversionSupplier(BiFunction<String, String, ? extends ExprRewrite> typeConversionSupplier) {
        this.typeConversionSupplier = typeConversionSupplier;
        return this;
    }

    public SchemaMapperImpl setTypePromotionStrategy(TypePromoter typePromotionStrategy) {
        this.typePromotionStrategy = typePromotionStrategy;
        return this;
    }

    public static String deriveSuffix(String datatype) {
        String result = SplitIRI.localname((String)datatype).toLowerCase();
        return result;
    }

    public SchemaMapping createSchemaMapping() {
        Objects.requireNonNull(this.sourceVars, "Source Variables not set");
        Objects.requireNonNull(this.sourceVarToDatatypes, "Mapping of source variables to datatypes not set");
        BiFunction<String, String, ExprRewrite> effectiveTypeConversionSupplier = this.typeConversionSupplier == null ? SchemaMapperImpl::defaultTypeConversionSupplier : this.typeConversionSupplier;
        TypePromoter effectiveTypePromoter = this.typePromotionStrategy == null ? types -> types.stream().collect(Collectors.toMap(e -> e, e -> e)) : this.typePromotionStrategy;
        Function<Var, Number> effectiveSourceVarToNulls = this.sourceVarToNulls == null ? var -> null : this.sourceVarToNulls;
        Function<Var, String> effectiveVarToFallbackDatatype = this.varToFallbackDatatype == null ? var -> null : this.varToFallbackDatatype;
        LinkedHashMap<Var, FieldMapping> tgtVarToMapping = new LinkedHashMap<Var, FieldMapping>();
        for (Var srcVar : this.sourceVars) {
            String fallbackDatatype;
            String srcVarName = srcVar.getName();
            ExprVar srcExprVar = new ExprVar(srcVar);
            Set<String> rawDatatypes = this.sourceVarToDatatypes.apply((Var)srcVar);
            Number nullStats = effectiveSourceVarToNulls.apply(srcVar);
            Map<String, String> typePromotions = effectiveTypePromoter.promoteTypes(rawDatatypes);
            new HashSet<String>(typePromotions.values()).forEach(x -> typePromotions.put((String)x, (String)x));
            rawDatatypes.stream().filter(dt -> !typePromotions.containsKey(dt)).forEach(x -> typePromotions.put((String)x, (String)x));
            List promotedDatatypes = rawDatatypes.stream().map(iri -> typePromotions.getOrDefault(iri, (String)iri)).distinct().sorted().collect(Collectors.toList());
            if (promotedDatatypes.isEmpty() && (fallbackDatatype = effectiveVarToFallbackDatatype.apply(srcVar)) != null) {
                promotedDatatypes.add(srcVarName);
            }
            if (this.typeRemap != null) {
                Map remaps = promotedDatatypes.stream().collect(Collectors.toMap(x -> x, x -> this.typeRemap.apply((String)x), (k1, k2) -> {
                    throw new IllegalStateException("should never happen");
                }, LinkedHashMap::new));
                promotedDatatypes = remaps.values().stream().filter(x -> x != null).distinct().collect(Collectors.toList());
                Iterator<Map.Entry<String, String>> it = typePromotions.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> e = it.next();
                    String remappedType = (String)remaps.get(e.getValue());
                    if (remappedType == null) {
                        it.remove();
                        continue;
                    }
                    e.setValue(remappedType);
                }
            }
            boolean singleDatatype = promotedDatatypes.size() == 1;
            boolean isNullable = nullStats == null || nullStats.longValue() > 0L || !singleDatatype;
            Collections.sort(promotedDatatypes, (a, b) -> SchemaMapperImpl.deriveSuffix(a).compareTo(SchemaMapperImpl.deriveSuffix(b)));
            SetMultimap inverse = (SetMultimap)Multimaps.invertFrom((Multimap)Multimaps.forMap(typePromotions), (Multimap)HashMultimap.create());
            for (String datatypeIri : promotedDatatypes) {
                String baseName = singleDatatype ? srcVarName : srcVarName + "_" + SchemaMapperImpl.deriveSuffix(datatypeIri);
                Var tgtVar = Var.alloc((String)baseName);
                DecisionTreeSparqlExpr dt2 = new DecisionTreeSparqlExpr();
                for (String srcDtIri : inverse.get((Object)datatypeIri)) {
                    if (!srcDtIri.equals(datatypeIri)) {
                        ExprRewrite typeConversion = effectiveTypeConversionSupplier.apply(srcDtIri, datatypeIri);
                        dt2.getRoot().getOrCreateInnerNode(null, (Expr)E_SerializableIdentity.wrap((Expr)SchemaMapperImpl.createDatatypeCheck((Expr)srcExprVar, srcDtIri))).getOrCreateLeafNode(NodeValue.TRUE.asNode()).setValue(E_SerializableIdentity.wrap((Expr)typeConversion.rewrite((Expr)srcExprVar)));
                        continue;
                    }
                    dt2.getRoot().getOrCreateInnerNode(null, (Expr)E_SerializableIdentity.wrap((Expr)SchemaMapperImpl.createDatatypeCheck((Expr)srcExprVar, datatypeIri))).getOrCreateLeafNode(NodeValue.TRUE.asNode()).setValue(E_SerializableIdentity.wrap((Expr)srcExprVar));
                }
                tgtVarToMapping.put(tgtVar, new FieldMappingImpl(tgtVar, dt2, datatypeIri, isNullable));
                if (!datatypeIri.equals(RDF.langString.getURI())) continue;
                Var tgtLangVar = Var.alloc((String)(baseName + "_lang"));
                DecisionTreeSparqlExpr langDt = new DecisionTreeSparqlExpr();
                langDt.getRoot().getOrCreateInnerNode(null, (Expr)E_SerializableIdentity.wrap((Expr)SchemaMapperImpl.createDatatypeCheck((Expr)srcExprVar, RDF.Nodes.langString.getURI()))).getOrCreateLeafNode(NodeValue.TRUE.asNode()).setValue(E_SerializableIdentity.wrap((Expr)new E_Lang((Expr)srcExprVar)));
                tgtVarToMapping.put(tgtLangVar, new FieldMappingImpl(tgtLangVar, langDt, XSD.xstring.getURI(), isNullable));
            }
        }
        SchemaMappingImpl result = new SchemaMappingImpl(tgtVarToMapping);
        return result;
    }

    public static ExprRewrite defaultTypeConversionSupplier(String srcDatatypeIri, String tgtDatatypeIri) {
        return arg -> new E_Function(tgtDatatypeIri, new ExprList(arg));
    }

    public static Expr createDatatypeCheck(Expr expr, String datatypeIri) {
        return switch (datatypeIri) {
            case "http://www.w3.org/ns/r2rml#IRI" -> new E_IsIRI(expr);
            case "http://www.w3.org/ns/r2rml#BlankNode" -> new E_IsBlank(expr);
            default -> new E_Equals((Expr)new E_Datatype(expr), (Expr)NodeValue.makeNode((Node)NodeFactory.createURI((String)datatypeIri)));
        };
    }

    public static String createColumnName(String varName, String datatypeIri) {
        return varName + datatypeIri;
    }

    public static SchemaMapperImpl newInstance() {
        return new SchemaMapperImpl();
    }
}

