/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.analytics;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.collector.core.AggBuilder;
import org.aksw.commons.collector.core.AggInputFilter;
import org.aksw.commons.collector.core.AggInputTransform;
import org.aksw.commons.collector.core.AggOutputTransform;
import org.aksw.commons.collector.domain.ParallelAggregator;
import org.aksw.commons.lambda.serializable.SerializableFunction;
import org.aksw.commons.lambda.serializable.SerializablePredicate;
import org.aksw.commons.lambda.serializable.SerializableSupplier;
import org.aksw.jenax.arq.analytics.PrefixAccumulator;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.apache.jena.graph.Node;

public class NodeAnalytics {
    public static <E> ParallelAggregator<Node, E, Map.Entry<Set<String>, Long>, ?> usedDatatypesAndNullCounts() {
        return AggBuilder.inputBroadcast(NodeAnalytics.usedDatatypes(), NodeAnalytics.nullCount());
    }

    public static <E> ParallelAggregator<Node, E, Long, ?> nullCount() {
        AggInputFilter result = AggBuilder.inputFilter((SerializablePredicate & Serializable)x -> x == null, (ParallelAggregator)AggBuilder.counting());
        return result;
    }

    public static <E> ParallelAggregator<Node, E, Set<String>, ?> usedDatatypes() {
        AggInputTransform result = AggBuilder.inputTransform((SerializableFunction & Serializable)node -> NodeUtils.getDatatypeIri((Node)node), (ParallelAggregator)AggBuilder.inputFilter(Objects::nonNull, (ParallelAggregator)AggBuilder.collectionSupplier((SerializableSupplier & Serializable)() -> new HashSet())));
        return result;
    }

    public static <E> ParallelAggregator<Node, E, Set<String>, ?> usedPrefixes(int targetSize) {
        AggInputFilter result = AggBuilder.inputFilter(Node::isURI, (ParallelAggregator)AggBuilder.inputTransform(Node::getURI, (ParallelAggregator)AggBuilder.naturalAccumulator((SerializableSupplier & Serializable)() -> new PrefixAccumulator(targetSize))));
        return result;
    }

    public static <E> ParallelAggregator<Node, E, Map<String, String>, ?> usedPrefixes(Map<String, String> prefixMap) {
        PatriciaTrie trie = new PatriciaTrie();
        prefixMap.forEach((p, i) -> trie.put(i, p));
        AggInputFilter tmp = AggBuilder.inputFilter((SerializablePredicate & Serializable)n -> n != null && n.isURI(), (ParallelAggregator)AggBuilder.inputTransform((SerializableFunction & Serializable)node -> {
            Map.Entry cand;
            String uri = node.getURI();
            Map.Entry e = uri.startsWith((String)(cand = trie.select((Object)uri)).getKey()) ? cand : null;
            return e;
        }, (ParallelAggregator)AggBuilder.inputFilter((SerializablePredicate & Serializable)e -> e != null, (ParallelAggregator)AggBuilder.mapSupplier((SerializableSupplier & Serializable)() -> new PatriciaTrie()))));
        AggOutputTransform result = AggBuilder.outputTransform((ParallelAggregator)tmp, (SerializableFunction & Serializable)som -> {
            Map<String, String> r = som.getMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            return r;
        });
        return result;
    }
}

