/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.decisiontree.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.aksw.jenax.arq.decisiontree.api.DtNode;
import org.aksw.jenax.arq.decisiontree.api.InnerNode;
import org.aksw.jenax.arq.decisiontree.api.InnerNodeImpl;
import org.aksw.jenax.arq.decisiontree.api.LeafNode;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.ExprUtils;

public class DecisionTreeSparqlBase<T>
implements Serializable {
    private static final long serialVersionUID = 0L;
    protected InnerNode<Expr, Node, T> root = new InnerNodeImpl(null, null, null);

    public InnerNode<Expr, Node, T> getRoot() {
        return this.root;
    }

    public void recursiveFind(Binding binding, DtNode<Expr, Node, T> node, Collection<LeafNode<Expr, Node, T>> outResults) {
        if (node.isLeafNode()) {
            outResults.add(node.asLeafNode());
        } else {
            Node eval;
            InnerNode<Expr, Node, T> innerNode = node.asInnerNode();
            Expr cond = innerNode.getClassifier();
            if (cond == null) {
                eval = null;
            } else {
                try {
                    NodeValue nv = ExprUtils.eval((Expr)cond, (Binding)binding);
                    eval = nv.asNode();
                }
                catch (ExprEvalException e) {
                    eval = null;
                }
            }
            LeafNode<Expr, Object, T> leaf = innerNode.getLeafNode(eval);
            if (leaf != null) {
                this.recursiveFind(binding, leaf, outResults);
            }
            Collection<InnerNode<Expr, Node, T>> inners = innerNode.getInnerNodes(eval);
            for (DtNode dtNode : inners) {
                this.recursiveFind(binding, dtNode, outResults);
            }
        }
    }

    public Collection<LeafNode<Expr, Node, T>> findLeafNodes(Binding binding) {
        LinkedHashSet<LeafNode<Expr, Node, T>> result = new LinkedHashSet<LeafNode<Expr, Node, T>>();
        this.recursiveFind(binding, this.getRoot(), result);
        return result;
    }

    public String toString() {
        return this.root.toString();
    }
}

