/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.analytics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.collector.core.AggBuilder;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.lambda.serializable.SerializableSupplier;
import org.aksw.jenax.arq.analytics.BindingAnalytics;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.engine.iterator.QueryIteratorResultSet;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTP;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTPBuilder;

public class PrefixAccumulator<E>
implements Accumulator<String, E, Set<String>>,
Serializable {
    private static final long serialVersionUID = -4653863475436646211L;
    protected PatriciaTrie<Long> prefixes = new PatriciaTrie();
    protected int targetSize;
    public static final Pattern pattern = Pattern.compile("(^([^/]*/){3})");

    public PrefixAccumulator(int targetSize) {
        this.targetSize = targetSize;
    }

    public Set<String> getValue() {
        Set result = this.prefixes.keySet();
        return result;
    }

    public static String defaultGrouper(String prefix) {
        Matcher m = pattern.matcher(prefix);
        String result = m.find() ? m.group(1) : null;
        System.out.println("group " + result + " for " + prefix);
        return result;
    }

    public static <T> Set<T> flatMapMapValues(Map<?, ? extends Collection<T>> map) {
        Set result = map.values().stream().flatMap(v -> v.stream()).collect(Collectors.toSet());
        return result;
    }

    public static String commonPrefix(String sa, String sb, boolean skipLast) {
        int i;
        char[] a = sa.toCharArray();
        char[] b = sb.toCharArray();
        int n = Math.min(a.length, b.length);
        char[] tmp = new char[n];
        for (i = 0; i < n && a[i] == b[i]; ++i) {
            tmp[i] = a[i];
        }
        if (skipLast) {
            --i;
        }
        String result = i < 0 ? null : new String(tmp, 0, i);
        return result;
    }

    public static String longestPrefixLookup(String lookup, boolean inclusive, SortedMap<String, ?> prefixes) {
        String result = null;
        String current = lookup;
        while (result == null) {
            if (prefixes.containsKey(current) && inclusive) {
                result = current;
                break;
            }
            inclusive = true;
            String candidate = null;
            SortedMap<String, ?> head = prefixes.headMap(current);
            if (!head.isEmpty()) {
                candidate = head.lastKey();
            }
            if (candidate == null) break;
            current = PrefixAccumulator.commonPrefix(current, candidate, false);
        }
        return result;
    }

    public static String longestCommonPrefix(PatriciaTrie<?> trie) {
        String result = null;
        int bestLength = 0;
        OrderedMapIterator it = trie.mapIterator();
        while (it.hasNext()) {
            it.next();
        }
        if (it.hasPrevious()) {
            String higher = (String)it.previous();
            while (it.hasPrevious()) {
                String lower = (String)it.previous();
                if (higher.length() <= bestLength) continue;
                String commonPrefix = PrefixAccumulator.commonPrefix(higher, lower, false);
                if (result == null || result.length() < commonPrefix.length()) {
                    result = commonPrefix;
                    bestLength = result.length();
                }
                higher = lower;
            }
        }
        return result;
    }

    public void removeSuperseded(String prefix) {
        int l = prefix.length();
        SortedMap map = this.prefixes.prefixMap((Object)prefix);
        ArrayList superseded = new ArrayList(map.keySet());
        for (String item : superseded) {
            if (item.length() == l) continue;
            this.prefixes.remove((Object)item);
        }
    }

    public void accumulate(String prefix, E env) {
        String lcp;
        String bestMatch = PrefixAccumulator.longestPrefixLookup(prefix, true, this.prefixes);
        this.removeSuperseded(prefix);
        if (bestMatch == null) {
            this.prefixes.put((Object)prefix, null);
        }
        if (this.prefixes.size() > this.targetSize && (lcp = PrefixAccumulator.longestCommonPrefix(this.prefixes)) != null) {
            this.removeSuperseded(lcp);
            this.prefixes.put((Object)lcp, null);
        }
    }

    public static void main(String[] args) {
        try (QueryExecution qe = (QueryExecution)((QueryExecutionHTTPBuilder)((QueryExecutionHTTPBuilder)QueryExecutionHTTP.create().endpoint("http://dbpedia.org/sparql")).query(QueryFactory.create((String)"Select * { ?s a <http://dbpedia.org/ontology/Airport> } Limit 100"))).build();){
            ResultSet rs = qe.execSelect();
            Accumulator acc = BindingAnalytics.usedPrefixes(50).createAccumulator();
            new QueryIteratorResultSet(rs).forEachRemaining(arg_0 -> ((Accumulator)acc).accumulate(arg_0));
            Map ps = (Map)acc.getValue();
            System.out.println("Prefixes: " + String.valueOf(ps));
        }
        List<String> items = Arrays.asList("dbr:Leipzig", "dbr:London", "dbr:City");
        PrefixAccumulator acc = new PrefixAccumulator(3);
        items.stream().forEach(arg_0 -> acc.accumulate(arg_0));
        System.out.println(acc.getValue());
        acc.accumulate("lgd:foo");
        System.out.println(acc.getValue());
        Set result = (Set)Stream.concat(items.stream(), Stream.of("lgd:foo")).collect(AggBuilder.naturalAccumulator((SerializableSupplier & Serializable)() -> new PrefixAccumulator(3)).asCollector());
        System.out.println(result);
    }
}

