/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.decisiontree.api;

import com.google.common.base.Optional;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aksw.jenax.arq.decisiontree.api.DtNodeBase;
import org.aksw.jenax.arq.decisiontree.api.InnerNode;
import org.aksw.jenax.arq.decisiontree.api.LeafNode;
import org.aksw.jenax.arq.decisiontree.api.LeafNodeImpl;
import org.aksw.jenax.arq.decisiontree.impl.jena.DtVisitorToString;

public class InnerNodeImpl<C, V, T>
extends DtNodeBase<C, V, T>
implements InnerNode<C, V, T>,
Serializable {
    private static final long serialVersionUID = 7046323103753590235L;
    protected C classifier;
    protected Table<Optional<V>, Optional<C>, InnerNode<C, V, T>> valueToConditionToInnerNode;
    protected Map<V, LeafNode<C, V, T>> valueToLeafNode;

    public InnerNodeImpl(InnerNode<C, V, T> parent, V reachingValue, C classifier) {
        super(parent, reachingValue);
        this.classifier = classifier;
        this.valueToConditionToInnerNode = HashBasedTable.create();
        this.valueToLeafNode = new HashMap<V, LeafNode<C, V, T>>();
    }

    @Override
    public InnerNode<C, V, T> getParent() {
        return this.parent;
    }

    @Override
    public C getClassifier() {
        return this.classifier;
    }

    @Override
    public Collection<? extends InnerNode<C, V, T>> getInnerNodes() {
        return this.valueToConditionToInnerNode.values();
    }

    @Override
    public Collection<? extends InnerNode<C, V, T>> getInnerNodes(Object value) {
        Optional rowKey = Optional.fromNullable((Object)value);
        Set result = this.valueToConditionToInnerNode.rowKeySet().contains(rowKey) ? this.valueToConditionToInnerNode.row((Object)Optional.fromNullable((Object)value)).values() : Collections.emptySet();
        return result;
    }

    @Override
    public InnerNode<C, V, T> getInnerNode(V value, C classifier) {
        InnerNode result = (InnerNode)this.valueToConditionToInnerNode.get((Object)Optional.fromNullable(value), (Object)Optional.fromNullable(classifier));
        return result;
    }

    @Override
    public InnerNode<C, V, T> getOrCreateInnerNode(V value, C classifier) {
        InnerNode<C, V, T> result = this.getInnerNode(value, classifier);
        if (result == null) {
            result = new InnerNodeImpl<C, V, T>(this, value, classifier);
            this.valueToConditionToInnerNode.put((Object)Optional.fromNullable(value), (Object)Optional.fromNullable(classifier), result);
        }
        return result;
    }

    @Override
    public Collection<? extends LeafNode<C, V, T>> getLeafNodes() {
        return this.valueToLeafNode.values();
    }

    @Override
    public LeafNode<C, V, T> getLeafNode(Object value) {
        return this.valueToLeafNode.get(value);
    }

    @Override
    public LeafNode<C, V, T> getOrCreateLeafNode(V value) {
        LeafNode<C, V, T> result = this.getLeafNode((Object)value);
        if (result == null) {
            result = new LeafNodeImpl(this, value);
            this.valueToLeafNode.put((LeafNode<C, V, T>)value, (LeafNode<C, LeafNode<C, V, T>, T>)result);
        }
        return result;
    }

    public String toString() {
        DtVisitorToString visitor = new DtVisitorToString();
        visitor.visit(this);
        String result = visitor.getResult();
        return result;
    }
}

