/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.decisiontree.impl.jena;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.aksw.jenax.arq.decisiontree.api.DtNode;
import org.aksw.jenax.arq.decisiontree.api.DtVisitor;
import org.aksw.jenax.arq.decisiontree.api.InnerNode;
import org.aksw.jenax.arq.decisiontree.api.LeafNode;
import org.apache.jena.atlas.io.IndentedWriter;

public class DtVisitorToString<C, V, T>
implements DtVisitor<C, V, T> {
    protected IndentedWriter writer;
    protected ByteArrayOutputStream out;

    public DtVisitorToString() {
        this.out = new ByteArrayOutputStream();
        this.writer = new IndentedWriter((OutputStream)this.out);
    }

    public DtVisitorToString(IndentedWriter writer) {
        this.writer = writer;
    }

    public String getResult() {
        this.writer.flush();
        return this.out.toString();
    }

    @Override
    public <X> X visit(InnerNode<C, V, T> node) {
        C classifier = node.getClassifier();
        Collection<InnerNode<C, V, T>> childInnerNodes = node.getInnerNodes();
        Collection<LeafNode<C, V, T>> childLeafNodes = node.getLeafNodes();
        boolean passThrough = false;
        if (classifier == null) {
            DtNode<C, V, T> onlyChild;
            if (childInnerNodes.size() == 1 && childLeafNodes.isEmpty()) {
                onlyChild = childInnerNodes.iterator().next();
                if (onlyChild.getReachingValue() == null) {
                    onlyChild.accept(this);
                    passThrough = true;
                }
            } else if (childLeafNodes.size() == 1 && childInnerNodes.isEmpty() && (onlyChild = childLeafNodes.iterator().next()).getReachingValue() == null) {
                onlyChild.accept(this);
                passThrough = true;
            }
        }
        if (!passThrough) {
            Object value;
            this.writer.println("SWITCH (" + String.valueOf(classifier) + ") {");
            for (InnerNode<C, V, T> innerNode : node.getInnerNodes()) {
                value = innerNode.getReachingValue();
                this.writer.println((String)(value == null ? "DEFAULT: " : "CASE " + String.valueOf(value) + ": ") + "{");
                this.writer.incIndent();
                innerNode.accept(this);
                this.writer.decIndent();
                this.writer.println("}");
            }
            for (LeafNode leafNode : node.getLeafNodes()) {
                value = leafNode.getReachingValue();
                this.writer.print((String)(value == null ? "DEFAULT: " : "CASE " + String.valueOf(value) + ": ") + "{ ");
                leafNode.accept(this);
                this.writer.println(" }");
            }
            this.writer.print("}");
        }
        return null;
    }

    @Override
    public <X> X visit(LeafNode<C, V, T> leafNode) {
        this.writer.print(leafNode.toString());
        return null;
    }
}

