/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.analytics.core;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.aksw.jenax.arq.aggregation.BestLiteralConfig;
import org.aksw.jenax.arq.aggregation.LiteralPreference;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.api.Fragment3;
import org.aksw.jenax.sparql.fragment.impl.Fragment3Impl;
import org.aksw.jenax.sparql.fragment.impl.FragmentImpl;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.expr.E_Lang;
import org.apache.jena.sparql.expr.E_LangMatches;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementLateral;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.vocabulary.RDFS;

public class LabelUtils {
    public static Fragment3 createRelationLiteralPreference(LiteralPreference literalPreference) {
        BestLiteralConfig blc = new BestLiteralConfig(literalPreference, Vars.x, Vars.y, Vars.z);
        Fragment3 result = LabelUtils.createRelationPrefLabels(blc);
        return result;
    }

    public static Fragment3 createRelationPrefLabels(BestLiteralConfig bestLiteralConfig) {
        List prefLangs = bestLiteralConfig.getLangs();
        List prefPreds = bestLiteralConfig.getPredicates();
        Var s = bestLiteralConfig.getSubjectVar();
        Var p = bestLiteralConfig.getPredicateVar();
        Var o = bestLiteralConfig.getObjectVar();
        ExprVar labelExpr = new ExprVar(o);
        List langTmp = prefLangs.stream().map(arg_0 -> LabelUtils.lambda$createRelationPrefLabels$0((Expr)labelExpr, arg_0)).collect(Collectors.toList());
        Expr langConstraint = ExprUtils.orifyBalanced(langTmp);
        E_OneOf propFilter = ExprUtils.oneOf((Node)p, (Iterable)prefPreds);
        ElementGroup els = new ElementGroup();
        els.addTriplePattern(Triple.create((Node)s, (Node)p, (Node)o));
        els.addElementFilter(new ElementFilter((Expr)propFilter));
        els.addElementFilter(new ElementFilter(langConstraint));
        Fragment3Impl result = new Fragment3Impl((Element)els, s, p, o);
        return result;
    }

    public static Fragment2 createFragmentPrefLabelsLateral(LiteralPreference config) {
        Var propertyVar = Vars.y;
        Var propertyScoreVar = Var.alloc((String)"propertyScore");
        Var langVar = Var.alloc((String)"lang");
        Var langScoreVar = Var.alloc((String)"langScore");
        Table langTable = TableFactory.create(Arrays.asList(langVar, langScoreVar));
        int i = 0;
        for (Object lang : config.getLangs()) {
            langTable.addBinding(BindingFactory.binding((Var)langVar, (Node)NodeFactory.createLiteral((String)lang), (Var)langScoreVar, (Node)NodeFactoryExtra.intToNode((int)i)));
            ++i;
        }
        Table propertyTable = TableFactory.create(Arrays.asList(propertyVar, propertyScoreVar));
        int i2 = 0;
        for (Node property : config.getPredicates()) {
            propertyTable.addBinding(BindingFactory.binding((Var)propertyVar, (Node)property, (Var)propertyScoreVar, (Node)NodeFactoryExtra.intToNode((int)i2)));
            ++i2;
        }
        Element scoreElt = ElementUtils.groupIfNeeded((Element[])new Element[]{ElementUtils.create((Table)propertyTable), ElementUtils.createElementTriple((Node)Vars.x, (Node)propertyVar, (Node)Vars.z), new ElementLateral(ElementUtils.groupIfNeeded((Element[])new Element[]{ElementUtils.create((Table)langTable), new ElementFilter((Expr)new E_LangMatches((Expr)new E_Lang((Expr)new ExprVar(Vars.z)), (Expr)new ExprVar(langVar)))}))});
        Query query = new Query();
        query.setQuerySelectType();
        query.setQueryPattern(scoreElt);
        query.setLimit(1L);
        ExprVar langScoreEv = new ExprVar(langScoreVar);
        ExprVar propertyScoreEv = new ExprVar(propertyScoreVar);
        if (config.isPreferProperties()) {
            query.addOrderBy((Expr)propertyScoreEv, 1);
            query.addOrderBy((Expr)langScoreEv, 1);
        } else {
            query.addOrderBy((Expr)langScoreEv, 1);
            query.addOrderBy((Expr)propertyScoreEv, 1);
        }
        Fragment2 result = FragmentImpl.create((Element)new ElementSubQuery(query), (Var[])new Var[]{Vars.x, Vars.z}).toFragment2();
        return result;
    }

    public static void main(String[] args) {
        LiteralPreference pref = new LiteralPreference(Arrays.asList("en", "de", ""), Arrays.asList(RDFS.label.asNode(), RDFS.comment.asNode(), RDFS.seeAlso.asNode()), false);
        Fragment2 fragment = LabelUtils.createFragmentPrefLabelsLateral(pref);
        System.out.println(fragment);
    }

    private static /* synthetic */ Expr lambda$createRelationPrefLabels$0(Expr labelExpr, String lang) {
        E_LangMatches r = new E_LangMatches((Expr)new E_Lang(labelExpr), (Expr)NodeValue.makeString((String)lang));
        return r;
    }
}

