/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.schema_mapping;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.collector.core.AggBuilder;
import org.aksw.commons.collector.core.AggLcaMap;
import org.aksw.commons.collector.core.AggOutputTransform;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.Aggregator;
import org.aksw.commons.collector.domain.ParallelAggregator;
import org.aksw.commons.lambda.serializable.SerializableFunction;
import org.aksw.commons.util.traverse.BreadthFirstSearchLib;
import org.aksw.jenax.arq.schema_mapping.TypePromoter;
import org.aksw.jenax.util.traversal.GraphSuccessorFunction;
import org.aksw.jenax.util.traversal.NaiveLCAFinder;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.vocabulary.RDFS;

public class TypePromoterImpl
implements TypePromoter {
    protected Aggregator<String, ?, Map<String, String>> typeAggregator;

    public TypePromoterImpl(Aggregator<String, ?, Map<String, String>> typeAggregator) {
        this.typeAggregator = typeAggregator;
    }

    @Override
    public Map<String, String> promoteTypes(Set<String> datatypeIris) {
        Accumulator acc = this.typeAggregator.createAccumulator();
        for (String datatypeIri : datatypeIris) {
            acc.accumulate((Object)datatypeIri);
        }
        Map actual = (Map)acc.getValue();
        Map<String, RDFDatatype> targetTypes = actual.values().stream().distinct().map(node -> new AbstractMap.SimpleEntry<String, RDFDatatype>((String)node, TypePromoterImpl.pullUpType(node))).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, RDFDatatype> mapping = actual.entrySet().stream().map(kv -> new AbstractMap.SimpleEntry<String, RDFDatatype>((String)kv.getKey(), (RDFDatatype)targetTypes.get(kv.getValue()))).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, String> result = mapping.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((RDFDatatype)e.getValue()).getURI()));
        Sets.SetView failedToMap = Sets.difference(actual.keySet(), mapping.keySet());
        boolean ignoreUnknownTypes = true;
        if (!ignoreUnknownTypes && !failedToMap.isEmpty()) {
            throw new RuntimeException("Failed to map: " + String.valueOf(failedToMap));
        }
        return result;
    }

    public static TypePromoter create() {
        Model model = RDFDataMgr.loadModel((String)"xsd-ontology.ttl");
        Graph graph = model.getGraph();
        GraphSuccessorFunction gsf = GraphSuccessorFunction.create((Node)RDFS.subClassOf.asNode(), (boolean)true);
        Set<Node> cappingTypes = Collections.singleton(NodeFactory.createURI((String)"http://www.w3.org/2001/XMLSchema#anyAtomicType"));
        NaiveLCAFinder lcaFinder = new NaiveLCAFinder(graph, (n, g) -> gsf.apply(n, g).filter(m -> !cappingTypes.contains(m)));
        AggOutputTransform typeAggregator = AggBuilder.outputTransform((ParallelAggregator)AggBuilder.inputTransform(NodeFactory::createURI, (ParallelAggregator)AggLcaMap.create((arg_0, arg_1) -> ((NaiveLCAFinder)lcaFinder).getLCA(arg_0, arg_1))), (SerializableFunction & Serializable)map -> map.entrySet().stream().collect(Collectors.toMap(e -> ((Node)e.getKey()).getURI(), e -> ((Node)e.getValue()).getURI())));
        TypePromoterImpl result = new TypePromoterImpl((Aggregator<String, ?, Map<String, String>>)typeAggregator);
        return result;
    }

    public static RDFDatatype pullUpType(String datatypeIri) {
        return TypePromoterImpl.pullUpType(NodeFactory.createURI((String)datatypeIri));
    }

    public static RDFDatatype pullUpType(Node datatype) {
        return TypePromoterImpl.pullUpType(Collections.singleton(datatype));
    }

    public static RDFDatatype pullUpType(Set<Node> start) {
        Model model = RDFDataMgr.loadModel((String)"xsd-ontology.ttl");
        Graph graph = model.getGraph();
        GraphSuccessorFunction gsf = GraphSuccessorFunction.create((Node)RDFS.subClassOf.asNode(), (boolean)true);
        TypeMapper tm = TypeMapper.getInstance();
        Stream breadthOfParentsStream = BreadthFirstSearchLib.stream(start, node -> gsf.apply(graph, node), Collectors::toSet);
        Map javaTypeMap = breadthOfParentsStream.map(set -> {
            Map<Node, RDFDatatype> map = set.stream().map(node -> Maps.immutableEntry((Object)node, (Object)tm.getTypeByName(node.getURI()))).filter(e -> e.getValue() != null && ((RDFDatatype)e.getValue()).getJavaClass() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return map;
        }).filter(map -> !map.isEmpty()).findFirst().orElse(null);
        RDFDatatype result = javaTypeMap == null ? null : (RDFDatatype)Iterables.getOnlyElement(javaTypeMap.values());
        return result;
    }
}

