/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.conjure.dataengine;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.aksw.commons.io.util.PathUtils;
import org.aksw.conjure.datasource.DatasetGraphRailed;
import org.aksw.conjure.datasource.PropertiesUtils;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngine;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngines;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.DecoratedRDFEngine;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RDFEngineFactory;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RDFEngineFactoryLegacyBase;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RDFEngineFactoryRegistry;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RdfDataSourceSpecBasicFromMap;
import org.aksw.jenax.dataaccess.sparql.link.transform.RDFLinkTransforms;
import org.apache.jena.sparql.core.DatasetGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFEngineFactoryRailed
extends RDFEngineFactoryLegacyBase {
    private static final Logger logger = LoggerFactory.getLogger(RDFEngineFactoryRailed.class);

    public RDFEngine create(Map<String, Object> config) throws Exception {
        Path confFile;
        RdfDataSourceSpecBasicFromMap spec = RdfDataSourceSpecBasicFromMap.wrap(config);
        Map.Entry fsInfo = PathUtils.resolveFsAndPath((String)spec.getLocationContext(), (String)spec.getLocation());
        Path path = (Path)fsInfo.getKey();
        String railSizeStr = (String)config.get("railSize");
        Long railSize = railSizeStr == null ? null : Long.valueOf(Long.parseLong(railSizeStr));
        Objects.requireNonNull(railSize, "Rail size must be specified (this should be roughly free ram / num partitions");
        Properties props = new Properties();
        if (path != null) {
            confFile = path.resolve("rpt-rail.properties");
            if (Files.exists(confFile, new LinkOption[0])) {
                PropertiesUtils.read(confFile, props);
            } else {
                boolean isEmptyDir;
                if (Files.exists(path, new LinkOption[0]) && !(isEmptyDir = Files.list(path).anyMatch(x -> true))) {
                    throw new RuntimeException("Creation of a railed store requires an empty directory");
                }
                props.putAll(config);
                Files.createDirectories(path, new FileAttribute[0]);
                PropertiesUtils.write(confFile, props);
            }
        } else {
            throw new RuntimeException("No location specified for railed dataset");
        }
        String delegateEngine = Objects.requireNonNull((String)config.get("delegate"), "No delegate engine set which to use for railing");
        RDFEngineFactory delegateFactory = RDFEngineFactoryRegistry.get().getFactory(delegateEngine);
        DatasetGraphRailed dg = new DatasetGraphRailed(confFile, delegateFactory);
        DecoratedRDFEngine result = RDFEngines.decorate((RDFEngine)RDFEngines.of((DatasetGraph)dg)).decorate(RDFLinkTransforms.withWorkerThread()).build();
        return result;
    }
}

