/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.conjure.dataengine;

import com.google.common.io.RecursiveDeleteOption;
import java.io.Closeable;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import org.aksw.commons.io.util.FileUtils;
import org.aksw.commons.io.util.PathUtils;
import org.aksw.commons.io.util.symlink.SymbolicLinkStrategies;
import org.aksw.commons.util.exception.FinallyRunAll;
import org.aksw.commons.util.function.ThrowingRunnable;
import org.aksw.difs.builder.DifsFactory;
import org.aksw.difs.system.domain.StoreDefinition;
import org.aksw.jenax.arq.engine.quad.RDFConnectionFactoryQuadForm;
import org.aksw.jenax.arq.service.vfs.ServiceExecutorFactoryRegistratorVfs;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngine;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngines;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RDFEngineFactoryLegacyBase;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RdfDataSourceSpecBasicFromMap;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSource;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSourceOverDatasetGraph;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.rdflink.RDFLinkAdapter;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFEngineFactoryDifs
extends RDFEngineFactoryLegacyBase {
    private static final Logger logger = LoggerFactory.getLogger(RDFEngineFactoryDifs.class);

    public RDFEngine create(Map<String, Object> config) throws Exception {
        boolean deleteWhenDone;
        RdfDataSourceSpecBasicFromMap spec = RdfDataSourceSpecBasicFromMap.wrap(config);
        if (spec.getLocation() == null) {
            throw new IllegalArgumentException("Dataset-in-FileSystem (Difs) engine requires the location of a store config file");
        }
        Map.Entry fsInfo = PathUtils.resolveFsAndPath((String)spec.getLocationContext(), (String)spec.getLocation());
        Path confFile = (Path)fsInfo.getKey();
        boolean canWrite = confFile.getFileSystem().equals(FileSystems.getDefault());
        final Context cxt = ARQ.getContext().copy();
        ServiceExecutorFactoryRegistratorVfs.register((Context)cxt);
        Path basePath = confFile.getParent();
        if (basePath == null) {
            throw new IllegalArgumentException("Location must be a file");
        }
        Path dftStorePath = basePath.resolve("store");
        Path dftIndexPath = basePath.resolve("index");
        boolean bl = deleteWhenDone = Boolean.TRUE.equals(spec.isAutoDeleteIfCreated()) && canWrite && !Files.exists(confFile, new LinkOption[0]) && !Files.exists(dftStorePath, new LinkOption[0]) && !Files.exists(dftIndexPath, new LinkOption[0]);
        if (deleteWhenDone) {
            logger.info(String.format("Creating temporary difs store with config file %s (files will be deleted when done)", confFile));
        }
        Path dftLocksPath = basePath.resolve("locks");
        Path dftTxnsPath = basePath.resolve("txns");
        if (deleteWhenDone) {
            for (Path validation : Arrays.asList(dftLocksPath, dftTxnsPath)) {
                if (!Files.exists(validation, new LinkOption[0])) continue;
                throw new IllegalStateException("Neither store/index folders nor config file found but either orphaned or unrelated file " + String.valueOf(validation) + " existed.");
            }
        }
        Path ancestorPath = FileUtils.getFirstExistingAncestor((Path)confFile);
        Files.createDirectories(basePath, new FileAttribute[0]);
        StoreDefinition defaultDefinition = ((StoreDefinition)ModelFactory.createDefaultModel().createResource().as(StoreDefinition.class)).setStorePath("store").setIndexPath("index").setAllowEmptyGraphs(Boolean.valueOf(true));
        DatasetGraph dataset = DifsFactory.newInstance().setStoreDefinition(defaultDefinition).setUseJournal(canWrite).setSymbolicLinkStrategy(SymbolicLinkStrategies.FILE).setConfigFile(confFile).setCreateIfNotExists(true).setMaximumNamedGraphCacheSize(10000L).connect();
        RDFLinkSourceOverDatasetGraph linkSource = new RDFLinkSourceOverDatasetGraph(dataset){

            public RDFLink newLink() {
                Dataset ds = DatasetFactory.wrap((DatasetGraph)this.getDatasetGraph());
                RDFConnection conn = RDFConnectionFactoryQuadForm.connect((Dataset)ds, (Context)cxt);
                RDFLink r = RDFLinkAdapter.adapt((RDFConnection)conn);
                return r;
            }
        };
        Closeable closeAction = () -> {
            if (deleteWhenDone) {
                logger.info(String.format("Deleting difs files based at %s", basePath));
                FinallyRunAll.run((ThrowingRunnable[])new ThrowingRunnable[]{() -> FileUtils.deleteRecursivelyIfExists((Path)dftIndexPath, (RecursiveDeleteOption[])new RecursiveDeleteOption[0]), () -> FileUtils.deleteRecursivelyIfExists((Path)dftStorePath, (RecursiveDeleteOption[])new RecursiveDeleteOption[0]), () -> FileUtils.deleteRecursivelyIfExists((Path)dftTxnsPath, (RecursiveDeleteOption[])new RecursiveDeleteOption[0]), () -> FileUtils.deleteRecursivelyIfExists((Path)dftLocksPath, (RecursiveDeleteOption[])new RecursiveDeleteOption[0]), () -> Files.deleteIfExists(confFile), () -> FileUtils.deleteEmptyFolders((Path)basePath, (Path)ancestorPath, (boolean)false), () -> ((Closeable)fsInfo.getValue()).close()});
            }
        };
        RDFEngine result = RDFEngines.of((RDFLinkSource)linkSource, (AutoCloseable)closeAction);
        return result;
    }
}

