/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.conjure.datasource;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;

public class PropertiesUtils {
    public static Properties read(Path path) throws IOException {
        return PropertiesUtils.read(path, new Properties());
    }

    public static Properties read(Path path, Properties props) throws IOException {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            props.load(in);
        }
        return props;
    }

    public static Properties write(Path path, Properties props) throws IOException {
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            props.store(out, null);
        }
        return props;
    }

    public static Map<String, Object> toStringObjectMap(Properties props) {
        Map result = Maps.transformValues((Map)Maps.fromProperties((Properties)props), v -> v);
        return result;
    }
}

