/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.conjure.datasource;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.aksw.commons.util.exception.FinallyRunAll;
import org.aksw.commons.util.lock.LockUtils;
import org.aksw.conjure.datasource.DatasetGraphHashPartitioned;
import org.aksw.conjure.datasource.HasByteSize;
import org.aksw.conjure.datasource.PropertiesUtils;
import org.aksw.jenax.dataaccess.sparql.common.TransactionalMultiplex;
import org.aksw.jenax.dataaccess.sparql.common.TransactionalWrapper;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngine;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RDFEngineFactory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.TxnType;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphQuads;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.G;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetGraphRailed
extends DatasetGraphQuads
implements TransactionalWrapper {
    private static final Logger logger = LoggerFactory.getLogger(DatasetGraphRailed.class);
    protected PrefixMap prefixes;
    protected long newRailCheckIntervalSize = 100000L;
    protected AtomicLong newRailCheckCount = new AtomicLong(0L);
    protected ReadWriteLock delegatesLock = new ReentrantReadWriteLock();
    protected List<DatasetGraph> delegates = new ArrayList<DatasetGraph>();
    protected TransactionalMultiplex<Transactional> transactional;
    protected Path railPropertiesFile;
    protected long railMemberSizeLimit;
    protected Properties railProperties;
    protected RDFEngineFactory memberFactory;

    protected void checkTxn() {
        DatasetGraph master = this.delegates.get(0);
        if (master.isInTransaction()) {
            TxnType type = null;
            for (int i = 1; i < this.delegates.size(); ++i) {
                DatasetGraph slave = this.delegates.get(i);
                if (slave.isInTransaction()) continue;
                if (type == null) {
                    type = master.transactionType();
                }
                slave.begin(type);
            }
        }
    }

    public static long getNumRailMembers(Properties props) {
        String numRailMembersStr = (String)props.get("numRailMembers");
        long numRailMembers = numRailMembersStr == null ? 0L : Long.parseLong(numRailMembersStr);
        return numRailMembers;
    }

    public static void setNumRailMembers(Properties props, long count) {
        props.put("numRailMembers", Long.toString(count));
    }

    public DatasetGraphRailed(Path railPropertiesFile, RDFEngineFactory delegateFactory) {
        this.railPropertiesFile = railPropertiesFile;
        this.memberFactory = delegateFactory;
        this.transactional = new TransactionalMultiplex<Transactional>(this.delegates){

            protected <X> X forEachR(Function<? super Transactional, X> handler) {
                return (X)LockUtils.runWithLock((Lock)DatasetGraphRailed.this.delegatesLock.readLock(), () -> {
                    DatasetGraphRailed.this.checkTxn();
                    return super.forEachR(handler);
                });
            }
        };
        try {
            this.railProperties = PropertiesUtils.read(railPropertiesFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        long numRailMembers = DatasetGraphRailed.getNumRailMembers(this.railProperties);
        String railSizeStr = (String)this.railProperties.get("railSize");
        Long railSize = railSizeStr == null ? null : Long.valueOf(Long.parseLong(railSizeStr));
        this.railMemberSizeLimit = Objects.requireNonNull(railSize, "Rail size must be specified (this should be roughly free ram / num partitions");
        if (numRailMembers == 0L) {
            this.addRail();
        } else {
            for (long i = 0L; i < numRailMembers; ++i) {
                Properties memberProps = (Properties)this.railProperties.clone();
                Path memberLoc = railPropertiesFile.resolveSibling("rail-" + i);
                memberProps.put("location", memberLoc.toString());
                try {
                    RDFEngine member = this.memberFactory.create(PropertiesUtils.toStringObjectMap(memberProps));
                    DatasetGraph dsg = Objects.requireNonNull(member.getLinkSource().getDatasetGraph());
                    this.delegates.add(dsg);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public PrefixMap prefixes() {
        return this.prefixes;
    }

    public boolean supportsTransactions() {
        return true;
    }

    public Transactional getDelegate() {
        return this.transactional;
    }

    protected void addRail() {
        RDFEngine member;
        long nextId = this.delegates.size();
        Properties memberProps = (Properties)this.railProperties.clone();
        this.railProperties.put("numRailMembers", Long.toString(nextId + 1L));
        try {
            PropertiesUtils.write(this.railPropertiesFile, this.railProperties);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Path memberLoc = this.railPropertiesFile.resolveSibling("rail-" + nextId);
        memberProps.put("location", memberLoc.toString());
        try {
            member = this.memberFactory.create(PropertiesUtils.toStringObjectMap(memberProps));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        DatasetGraph tmp = Objects.requireNonNull(member.getLinkSource().getDatasetGraph());
        this.delegates.add(tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Quad quad) {
        block10: {
            long cnt = this.newRailCheckCount.incrementAndGet();
            long byteSize = -1L;
            boolean usedWriteLock = false;
            try {
                this.delegatesLock.readLock().lock();
                this.checkTxn();
                int numDelegates = this.delegates.size();
                DatasetGraph delegate = this.delegates.get(numDelegates - 1);
                boolean doAdd = true;
                for (int i = 0; i < numDelegates - 1; ++i) {
                    if (!this.delegates.get(i).contains(quad)) continue;
                    doAdd = false;
                    break;
                }
                if (doAdd) {
                    delegate.add(quad);
                }
                if (cnt % this.newRailCheckIntervalSize != 1L || (byteSize = ((HasByteSize)delegate).getByteSize()) <= this.railMemberSizeLimit) break block10;
                this.delegatesLock.readLock().unlock();
                logger.info(String.format("Adding rail graph; size %d >= threshold %d", byteSize, this.railMemberSizeLimit));
                usedWriteLock = true;
                this.delegatesLock.writeLock().lock();
                try {
                    if (this.delegates.size() == numDelegates) {
                        this.addRail();
                    }
                }
                finally {
                    this.delegatesLock.writeLock().unlock();
                }
            }
            finally {
                if (!usedWriteLock) {
                    this.delegatesLock.readLock().unlock();
                }
            }
        }
    }

    public void delete(Quad quad) {
        LockUtils.runWithLock((Lock)this.delegatesLock.readLock(), () -> {
            this.checkTxn();
            for (DatasetGraph delegate : this.delegates) {
                delegate.delete(quad);
            }
        });
    }

    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        return (Iterator)LockUtils.runWithLock((Lock)this.delegatesLock.readLock(), () -> {
            this.checkTxn();
            return DatasetGraphHashPartitioned.find(this.delegates, g, s, p, o);
        });
    }

    public Iterator<Quad> findNG(Node g, Node s, Node p, Node o) {
        return (Iterator)LockUtils.runWithLock((Lock)this.delegatesLock.readLock(), () -> {
            this.checkTxn();
            return DatasetGraphHashPartitioned.findNG(this.delegates, g, s, p, o);
        });
    }

    public Graph getDefaultGraph() {
        return GraphView.createDefaultGraph((DatasetGraph)this);
    }

    public Graph getGraph(Node graphNode) {
        return GraphView.createNamedGraph((DatasetGraph)this, (Node)graphNode);
    }

    public void addGraph(Node graphName, Graph graph) {
        G.triples2quads((Node)graphName, (Iterator)graph.find()).forEach(this::add);
    }

    public void close() {
        LockUtils.runWithLock((Lock)this.delegatesLock.readLock(), () -> {
            FinallyRunAll fin = FinallyRunAll.create();
            for (DatasetGraph dg : this.delegates) {
                fin.add(() -> ((DatasetGraph)dg).close());
            }
            fin.run();
        });
    }
}

