/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.conjure.datasource;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.commons.util.exception.FinallyRunAll;
import org.aksw.jenax.dataaccess.sparql.common.TransactionalMultiplex;
import org.aksw.jenax.dataaccess.sparql.common.TransactionalWrapper;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphQuads;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.G;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class DatasetGraphHashPartitioned
extends DatasetGraphQuads
implements TransactionalWrapper {
    protected PrefixMap prefixes = PrefixMapFactory.create();
    protected Function<Quad, Integer> hashFunction;
    protected List<DatasetGraph> delegates;
    protected TransactionalMultiplex<Transactional> transactional;

    public static DatasetGraph createBySubject(List<DatasetGraph> delegates) {
        return new DatasetGraphHashPartitioned(delegates, DatasetGraphHashPartitioned::subjectToHash);
    }

    public static Integer subjectToHash(Quad quad) {
        Node s = quad.getSubject();
        Integer result = s == null || Node.ANY.equals((Object)s) ? null : Integer.valueOf(s.hashCode());
        return result;
    }

    public DatasetGraphHashPartitioned(List<DatasetGraph> delegates, Function<Quad, Integer> hashFunction) {
        this.hashFunction = hashFunction;
        this.delegates = delegates;
        this.transactional = new TransactionalMultiplex(delegates);
    }

    public PrefixMap prefixes() {
        return this.prefixes;
    }

    public boolean supportsTransactions() {
        return true;
    }

    public Transactional getDelegate() {
        return this.transactional;
    }

    public static Iterator<Quad> findNG(Collection<DatasetGraph> delegates, Node g, Node s, Node p, Node o) {
        List iters = delegates.stream().map(dg -> dg.findNG(g, s, p, o)).collect(Collectors.toList());
        ExtendedIterator result = WrappedIterator.createIteratorIterator(iters.iterator());
        return result;
    }

    public static Iterator<Quad> find(Collection<DatasetGraph> delegates, Node g, Node s, Node p, Node o) {
        List iters = delegates.stream().map(dg -> dg.find(g, s, p, o)).collect(Collectors.toList());
        ExtendedIterator result = WrappedIterator.createIteratorIterator(iters.iterator());
        return result;
    }

    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        Iterator result;
        Quad quad = new Quad(g, s, p, o);
        Integer hash = this.hashFunction.apply(quad);
        if (hash == null) {
            result = DatasetGraphHashPartitioned.find(this.delegates, g, s, p, o);
        } else {
            int index = hash % this.delegates.size();
            DatasetGraph dg = this.delegates.get(index);
            result = dg.find(g, s, p, o);
        }
        return result;
    }

    public Iterator<Quad> findNG(Node g, Node s, Node p, Node o) {
        Iterator result;
        Quad quad = new Quad(g, s, p, o);
        Integer hash = this.hashFunction.apply(quad);
        if (hash == null) {
            result = DatasetGraphHashPartitioned.findNG(this.delegates, g, s, p, o);
        } else {
            int index = this.hashToIndex(hash);
            DatasetGraph dg = this.delegates.get(index);
            result = dg.find(g, s, p, o);
        }
        return result;
    }

    protected int quadToIndex(Quad quad) {
        int hash = this.hashFunction.apply(quad);
        int r = this.hashToIndex(hash);
        return r;
    }

    protected int hashToIndex(int hash) {
        return Math.abs(hash) % this.delegates.size();
    }

    public void add(Quad quad) {
        int index = this.quadToIndex(quad);
        DatasetGraph dg = this.delegates.get(index);
        dg.add(quad);
    }

    public void delete(Quad quad) {
        int index = this.quadToIndex(quad);
        DatasetGraph dg = this.delegates.get(index);
        dg.delete(quad);
    }

    public Graph getDefaultGraph() {
        return GraphView.createDefaultGraph((DatasetGraph)this);
    }

    public Graph getGraph(Node graphNode) {
        return GraphView.createNamedGraph((DatasetGraph)this, (Node)graphNode);
    }

    public void addGraph(Node graphName, Graph graph) {
        G.triples2quads((Node)graphName, (Iterator)graph.find()).forEach(this::add);
    }

    public void close() {
        FinallyRunAll fin = FinallyRunAll.create();
        for (DatasetGraph dg : this.delegates) {
            fin.add(() -> ((DatasetGraph)dg).close());
        }
        fin.run();
    }
}

