/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.conjure.dataengine;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.aksw.jenax.sparql.query.rx.RDFDataMgrEx;
import org.apache.jena.atlas.data.BagFactory;
import org.apache.jena.atlas.data.DefaultDataBag;
import org.apache.jena.atlas.data.SerializationFactory;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.data.ThresholdPolicyFactory;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RiotException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.modify.UpdateEngineWorker;
import org.apache.jena.sparql.modify.request.UpdateLoad;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.system.SerializationFactoryFinder;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.update.UpdateException;

public class UpdateEngineWorkerLoadAsGiven
extends UpdateEngineWorker {
    public UpdateEngineWorkerLoadAsGiven(DatasetGraph datasetGraph, Binding inputBinding, Context context) {
        super(datasetGraph, inputBinding, context);
    }

    public void visit(UpdateLoad update) {
        String source = update.getSource();
        Node dest = update.getDest();
        this.executeOperation(update.isSilent(), () -> {
            block9: {
                Graph graph = UpdateEngineWorkerLoadAsGiven.graphOrThrow((DatasetGraph)this.datasetGraph, (Node)dest);
                try {
                    boolean loadBuffered;
                    boolean bl = loadBuffered = update.isSilent() || !this.datasetGraph.supportsTransactionAbort();
                    if (dest == null) {
                        if (loadBuffered) {
                            DatasetGraph dsg2 = DatasetGraphFactory.create();
                            RDFDataMgrEx.readAsGiven((DatasetGraph)dsg2, (String)source);
                            dsg2.find().forEachRemaining(arg_0 -> ((DatasetGraph)this.datasetGraph).add(arg_0));
                        } else {
                            RDFDataMgrEx.readAsGiven((DatasetGraph)this.datasetGraph, (String)source);
                        }
                        return;
                    }
                    TypedInputStream input = RDFDataMgr.open((String)source);
                    String contentType = input.getContentType();
                    Lang lang = RDFDataMgr.determineLang((String)source, (String)contentType, (Lang)Lang.TTL);
                    if (lang == null) {
                        throw new UpdateException("Failed to determine the syntax for '" + source + "'");
                    }
                    if (!RDFLanguages.isTriples((Lang)lang)) {
                        throw new UpdateException("Attempt to load quads into a graph");
                    }
                    RDFParser parser = RDFParser.source((InputStream)input.getInputStream()).forceLang(lang).build();
                    if (loadBuffered) {
                        Graph g = GraphFactory.createGraphMem();
                        parser.parse(g);
                        GraphUtil.addInto((Graph)graph, (Graph)g);
                    } else {
                        parser.parse(graph);
                    }
                }
                catch (RiotException ex) {
                    if (update.isSilent()) break block9;
                    throw new UpdateException("Failed to LOAD '" + source + "' :: " + ex.getMessage(), (Throwable)ex);
                }
            }
        });
    }

    protected boolean executeOperation(boolean isSilent, Runnable action) {
        try {
            action.run();
            return true;
        }
        catch (UpdateException ex) {
            if (isSilent) {
                return false;
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(UpdateModify update) {
        Node withGraph = update.getWithIRI();
        Element elt = update.getWherePattern();
        DatasetGraph dsg = this.processUsing(update);
        if (dsg == null && withGraph != null) {
            elt = new ElementNamedGraph(withGraph, elt);
        }
        if (dsg == null) {
            dsg = this.datasetGraph;
        }
        ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext((Context)this.datasetGraph.getContext());
        try (DefaultDataBag db = BagFactory.newDefaultBag((ThresholdPolicy)policy, (SerializationFactory)SerializationFactoryFinder.bindingSerializationFactory());){
            Iterator bindings = this.evalBindings(elt);
            try {
                db.addAll(bindings);
            }
            finally {
                Iter.close((Iterator)bindings);
            }
            Iterator it = db.iterator();
            UpdateEngineWorkerLoadAsGiven.execDelete((DatasetGraph)this.datasetGraph, (List)update.getDeleteQuads(), (Node)withGraph, (Iterator)it);
            Iter.close((Iterator)it);
            Iterator it2 = db.iterator();
            UpdateEngineWorkerLoadAsGiven.execInsert((DatasetGraph)this.datasetGraph, (List)update.getInsertQuads(), (Node)withGraph, (Iterator)it2);
            Iter.close((Iterator)it2);
        }
    }
}

