/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.conjure.dataengine;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aksw.jenax.dataaccess.sparql.creator.FileSet;
import org.aksw.jenax.dataaccess.sparql.creator.FileSetMatcher;
import org.aksw.jenax.dataaccess.sparql.creator.FileSetOverPathMatcher;
import org.aksw.jenax.dataaccess.sparql.creator.FileSets;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngine;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngines;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RDFEngineFactoryLegacyBase;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RdfDataSourceSpecBasic;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RdfDataSourceSpecBasicFromMap;
import org.aksw.jenax.dataaccess.sparql.link.transform.RDFLinkTransforms;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSource;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSourceOverDatasetGraph;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.tdb2.TDB2Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFEngineFactoryTDB2
extends RDFEngineFactoryLegacyBase {
    private static final Logger logger = LoggerFactory.getLogger(RDFEngineFactoryTDB2.class);

    public RDFEngine create(Map<String, Object> config) throws Exception {
        RDFEngine result;
        RdfDataSourceSpecBasicFromMap spec = RdfDataSourceSpecBasicFromMap.wrap(config);
        RDFEngineFactoryLegacyBase.CloseablePath entry = RDFEngineFactoryLegacyBase.setupPath((String)"rpt-tdb2-", (RdfDataSourceSpecBasic)spec);
        Path finalDbPath = entry.path();
        Closeable partialCloseAction = entry.closeable();
        boolean autoDeleteRequested = Boolean.TRUE.equals(spec.isAutoDeleteIfCreated());
        FileSetOverPathMatcher tdbFileSet = new FileSetOverPathMatcher(finalDbPath, (FileSetMatcher)new FileSetMatcherTdb2());
        boolean deleteOnClose = autoDeleteRequested && tdbFileSet.isEmpty();
        Location location = Location.create((Path)finalDbPath);
        try {
            DatasetGraph dg = TDB2Factory.connectDataset((Location)location).asDatasetGraph();
            if (logger.isInfoEnabled()) {
                logger.info("Connecting to TDB2 database in folder " + String.valueOf(finalDbPath));
            }
            Closeable finalDeleteAction = () -> RDFEngineFactoryTDB2.lambda$create$0(dg, deleteOnClose, (FileSet)tdbFileSet, partialCloseAction);
            RDFLinkSourceOverDatasetGraph linkSource = new RDFLinkSourceOverDatasetGraph(dg);
            result = RDFEngines.of((RDFLinkSource)linkSource, (AutoCloseable)finalDeleteAction);
            result = RDFEngines.decorate((RDFEngine)result).decorate(RDFLinkTransforms.withAutoTxn()).decorate(RDFLinkTransforms.withWorkerThread()).build();
        }
        catch (Exception e) {
            partialCloseAction.close();
            throw new RuntimeException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$create$0(DatasetGraph dg, boolean deleteOnClose, FileSet tdbFileSet, Closeable partialCloseAction) throws IOException {
        try {
            dg.close();
            if (deleteOnClose) {
                logger.info("Attempting to delete TDB2 folder");
                tdbFileSet.delete();
            }
        }
        finally {
            partialCloseAction.close();
        }
    }

    public class FileSetMatcherTdb2
    implements FileSetMatcher {
        public List<Path> match(Path basePath) throws IOException {
            ArrayList dataFolders = new ArrayList();
            FileSets.accumulate(dataFolders, (Path)basePath, (String)"Data*");
            ArrayList<Path> result = new ArrayList<Path>();
            FileSets.accumulateIfExists(result, (Path)basePath.resolve("tdb.lock"));
            for (Path dataFolder : dataFolders) {
                FileSets.listPathsDepthFirst(result, (Path)dataFolder);
            }
            return result;
        }
    }
}

