/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.conjure.dataengine;

import com.google.common.collect.Maps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.aksw.commons.io.util.PathUtils;
import org.aksw.commons.util.exception.FinallyRunAll;
import org.aksw.conjure.dataengine.RDFEngineFactoryRailed;
import org.aksw.conjure.datasource.DatasetGraphDelegateWithWorkerThread;
import org.aksw.conjure.datasource.DatasetGraphHashPartitioned;
import org.aksw.conjure.datasource.PropertiesUtils;
import org.aksw.jenax.arq.util.dataset.HasDataset;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngine;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngines;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RDFEngineFactoryLegacyBase;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RdfDataSourceSpecBasicFromMap;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSource;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSourceOverDatasetGraph;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.sparql.core.DatasetGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFEngineFactoryPartitioned
extends RDFEngineFactoryLegacyBase {
    private static final Logger logger = LoggerFactory.getLogger(RDFEngineFactoryPartitioned.class);

    public RDFEngine create(Map<String, Object> config) throws Exception {
        RdfDataSourceSpecBasicFromMap spec = RdfDataSourceSpecBasicFromMap.wrap(config);
        Map.Entry fsInfo = PathUtils.resolveFsAndPath((String)spec.getLocationContext(), (String)spec.getLocation());
        Path path = (Path)fsInfo.getKey();
        Properties props = new Properties();
        if (path != null) {
            Path confFile = path.resolve("rpt-partition.properties");
            if (Files.exists(confFile, new LinkOption[0])) {
                PropertiesUtils.read(confFile, props);
            } else {
                boolean isEmptyDir;
                if (Files.exists(path, new LinkOption[0]) && !(isEmptyDir = Files.list(path).anyMatch(x -> true))) {
                    throw new RuntimeException("Creation of a partitioned store requires an empty directory");
                }
                props.putAll(config);
                if (!props.containsKey("partitions")) {
                    props.setProperty("partitions", Integer.toString(Runtime.getRuntime().availableProcessors()));
                }
                Files.createDirectories(path, new FileAttribute[0]);
                PropertiesUtils.write(confFile, props);
            }
        }
        String delegateEngine = Objects.requireNonNull((String)props.get("delegate"), "No delegate engine set which to use for partitioning");
        int numPartitions = Integer.parseInt(Objects.requireNonNull(props.getProperty("partitions"), "Number of partitions not specified"));
        RDFEngineFactoryRailed delegateFactory = new RDFEngineFactoryRailed();
        ArrayList<RDFEngine> partitions = new ArrayList<RDFEngine>();
        FinallyRunAll closePartAction = FinallyRunAll.create();
        for (int i = 0; i < numPartitions; ++i) {
            Properties partProps = (Properties)props.clone();
            Path partLoc = path.resolve("part-" + i);
            partProps.put("location", partLoc.toString());
            Map partMap = Maps.transformValues((Map)Maps.fromProperties((Properties)partProps), v -> v);
            RDFEngine engine = delegateFactory.create(partMap);
            closePartAction.addThrowing(() -> engine.close());
            if (engine.getLinkSource().getDatasetGraph() == null) {
                throw new RuntimeException("Partitioning currently requires backing engines to be backed by datasets");
            }
            partitions.add(engine);
        }
        final List<DatasetGraph> dsgs = partitions.stream().map(x -> ((HasDataset)x).getDataset().asDatasetGraph()).collect(Collectors.toList());
        DatasetGraph ds = DatasetGraphHashPartitioned.createBySubject(dsgs);
        RDFLinkSourceOverDatasetGraph linkSource = new RDFLinkSourceOverDatasetGraph(ds){

            public RDFLink newLink() {
                List<DatasetGraph> guardedDsgs = dsgs.stream().map(DatasetGraphDelegateWithWorkerThread::wrap).collect(Collectors.toList());
                DatasetGraph xds = DatasetGraphHashPartitioned.createBySubject(guardedDsgs);
                return RDFLink.connect((DatasetGraph)xds);
            }
        };
        RDFEngine result = RDFEngines.of((RDFLinkSource)linkSource, () -> ((DatasetGraph)ds).close());
        return result;
    }
}

