/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.conjure.dataengine;

import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import org.aksw.commons.io.util.PathUtils;
import org.aksw.jena_sparql_api.io.binseach.GraphFindCache;
import org.aksw.jena_sparql_api.io.binseach.StageGeneratorGraphFindRaw;
import org.aksw.jenax.arq.service.vfs.ServiceExecutorFactoryRegistratorVfs;
import org.aksw.jenax.arq.service.vfs.ServiceExecutorFactoryVfsUtils;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngine;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngines;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RDFEngineFactoryLegacyBase;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RdfDataSourceSpecBasicFromMap;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.util.Context;

public class RDFEngineFactoryBinSearch
extends RDFEngineFactoryLegacyBase {
    public RDFEngine create(Map<String, Object> config) throws Exception {
        RdfDataSourceSpecBasicFromMap spec = RdfDataSourceSpecBasicFromMap.wrap(config);
        if (spec.getLocation() == null) {
            throw new IllegalArgumentException("Binary search engine requires a path or URL to a sorted n-triples file.");
        }
        Map.Entry fsInfo = PathUtils.resolveFsAndPath((String)spec.getLocationContext(), (String)spec.getLocation());
        Path dataFile = (Path)fsInfo.getKey();
        if (!Files.exists(dataFile, new LinkOption[0])) {
            throw new FileNotFoundException("File does not exist: " + String.valueOf(dataFile.toAbsolutePath()));
        }
        Context cxt = ARQ.getContext().copy();
        ServiceExecutorFactoryRegistratorVfs.register((Context)cxt);
        Graph graph = ServiceExecutorFactoryVfsUtils.createGraphBinSearch((Path)dataFile, (Context)cxt);
        DatasetGraph ds = DatasetGraphFactory.wrap((Graph)graph);
        ds.getContext().set(ARQ.stageGenerator, (Object)new StageGeneratorGraphFindRaw());
        ds.getContext().set(GraphFindCache.graphCache, (Object)new GraphFindCache(10000));
        RDFEngine result = RDFEngines.of((DatasetGraph)ds);
        return result;
    }
}

