/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.conjure.cli.main;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.conjure.cli.config.ConfigConjureSparkBase;
import org.aksw.conjure.cli.config.ConjureCliArgs;
import org.aksw.conjure.cli.config.SpringSourcesConfig;
import org.aksw.conjure.cli.main.CommandMain;
import org.aksw.conjure.cli.main.ConfigCliConjureNative;
import org.aksw.dcat.jena.domain.api.DcatDataset;
import org.aksw.jena_sparql_api.common.DefaultPrefixes;
import org.aksw.jena_sparql_api.conjure.datapod.api.RdfDataPod;
import org.aksw.jena_sparql_api.conjure.dataref.rdf.api.RdfDataRef;
import org.aksw.jena_sparql_api.conjure.dataref.rdf.api.RdfDataRefDcat;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.Op;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpDataRefResource;
import org.aksw.jena_sparql_api.conjure.dataset.algebra.OpVisitor;
import org.aksw.jena_sparql_api.conjure.dataset.engine.ConjureFormatConfig;
import org.aksw.jena_sparql_api.conjure.dataset.engine.ExecutionUtils;
import org.aksw.jena_sparql_api.conjure.dataset.engine.OpExecutorDefault;
import org.aksw.jena_sparql_api.conjure.dataset.engine.TaskContext;
import org.aksw.jena_sparql_api.conjure.job.api.Job;
import org.aksw.jena_sparql_api.http.repository.api.HttpResourceRepositoryFromFileSystem;
import org.aksw.jena_sparql_api.http.repository.api.ResourceStore;
import org.aksw.jena_sparql_api.http.repository.impl.HttpResourceRepositoryFromFileSystemImpl;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.reprogen.core.JenaPluginUtils;
import org.aksw.jenax.sparql.query.rx.SparqlRx;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.core.SparqlStmtParser;
import org.aksw.jenax.stmt.core.SparqlStmtParserImpl;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.graph.NodeTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;

@SpringBootApplication
public class MainCliConjureNative {
    public static String URL_SCHEME_FILE = "file://";
    private static final Logger logger = LoggerFactory.getLogger(MainCliConjureNative.class);
    public static CommandMain cm;

    public static Map<String, byte[]> loadSources(Path basePath, Collection<String> sources) {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        for (String source : sources) {
            Path path = MainCliConjureNative.resolvePath(basePath, source);
            if (path == null) continue;
            try {
                byte[] content = Files.readAllBytes(path);
                result.put(source, content);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static BiMap<String, Path> writeFiles(Path baseFolder, Map<String, byte[]> sourceToContent) throws IOException {
        HashBiMap result = HashBiMap.create();
        for (Map.Entry<String, byte[]> e : sourceToContent.entrySet()) {
            String source = e.getKey();
            Path tmpPath = Paths.get(source, new String[0]);
            Path relPath = tmpPath.getFileName();
            byte[] content = e.getValue();
            Path absPath = baseFolder.resolve(relPath);
            logger.info("Writing file " + String.valueOf(relPath) + " with " + content.length + " to " + String.valueOf(absPath));
            Files.createDirectories(absPath.getParent(), new FileAttribute[0]);
            Files.write(absPath, content, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            result.put((Object)source, (Object)absPath);
        }
        return result;
    }

    public static Set<String> toFileUris(Collection<Path> paths) {
        Set<String> result = paths.stream().map(MainCliConjureNative::toFileUri).collect(Collectors.toSet());
        return result;
    }

    public static String toFileUri(Path path) {
        String result = path.toUri().toString();
        return result;
    }

    public static URL resolveOnClassPath(ClassLoader classLoader, String path) {
        URL result = classLoader.getResource(path);
        if (result != null) {
            try {
                InputStream in = result.openStream();
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                result = null;
            }
        }
        return result;
    }

    public static String canonicalizeSource(Path basePath, String arg) {
        Path path = MainCliConjureNative.resolvePath(basePath, arg);
        String result = path == null ? arg : MainCliConjureNative.toFileUri(path);
        return result;
    }

    public static Path resolvePath(Path basePath, String arg) {
        Path result = arg.startsWith(URL_SCHEME_FILE) ? Paths.get(arg.substring(URL_SCHEME_FILE.length()), new String[0]) : (arg.startsWith("/") ? Paths.get(arg, new String[0]) : (MainCliConjureNative.resolveOnClassPath(MainCliConjureNative.class.getClassLoader(), arg) != null ? null : (arg.contains(":/") ? null : basePath.resolve(arg))));
        return result;
    }

    public static Op loadConjureJob(String fileOrUri) {
        Model model = RDFDataMgr.loadModel((String)fileOrUri);
        List ops = model.listSubjects().mapWith(x -> (Op)JenaPluginUtils.polymorphicCast((RDFNode)x, Op.class)).toList();
        Op result = (Op)ops.iterator().next();
        return result;
    }

    public static void main(String[] args) throws Exception {
        ConjureCliArgs cliArgs = ConjureCliArgs.parse(args);
        if (cliArgs.getCm().help) {
            cliArgs.getJcommander().usage();
            return;
        }
        SpringSourcesConfig config = ConfigConjureSparkBase.parseArgs(cliArgs);
        Set<String> sources = config.getSources();
        SpringApplication app = new SpringApplicationBuilder(new Class[0]).sources(new Class[]{ConfigConjureSparkBase.class, ConfigCliConjureNative.class}).bannerMode(Banner.Mode.OFF).headless(false).web(WebApplicationType.NONE).build();
        app.setSources(sources);
        ConfigurableApplicationContext ctx = app.run(args);
        if (ctx != null) {
            ctx.close();
        }
    }

    public static RDFNode clone(RDFNode rdfNode) {
        Model clone = ModelFactory.createDefaultModel();
        clone.add(rdfNode.getModel());
        RDFNode result = rdfNode.inModel(clone);
        return result;
    }

    public static List<TaskContext> createTasksContexts(RdfDataRef catalogDataRef, Job job, HttpResourceRepositoryFromFileSystem repo, RDFFormat catalogFormat) throws Exception {
        RdfDataRef clone = (RdfDataRef)JenaPluginUtils.polymorphicCast((RDFNode)MainCliConjureNative.clone((RDFNode)catalogDataRef), RdfDataRef.class);
        OpDataRefResource catalogWorkflow = OpDataRefResource.from((Model)clone.getModel(), (RdfDataRef)clone);
        SparqlStmtParser parser = SparqlStmtParser.wrapWithOptimizePrefixes((Function)SparqlStmtParserImpl.create((Syntax)Syntax.syntaxARQ, (PrefixMapping)DefaultPrefixes.get(), (boolean)false));
        OpExecutorDefault catalogExecutor = new OpExecutorDefault(null, repo, new TaskContext((Resource)job, new HashMap(), new HashMap()), new HashMap(), catalogFormat);
        String queryStr = "CONSTRUCT {\n        ?a ?b ?c .\n        ?c ?d ?e\n      } {\n\n        { SELECT DISTINCT ?a {\n          ?a dcat:distribution [\n          ]\n        } }\n\n        ?a ?b ?c\n        OPTIONAL { ?c ?d ?e }\n}";
        Query dcatQuery = ((SparqlStmt)parser.apply(queryStr)).getAsQueryStmt().getQuery();
        ArrayList<TaskContext> taskContexts = new ArrayList<TaskContext>();
        try (RdfDataPod catalog = (RdfDataPod)catalogWorkflow.accept((OpVisitor)catalogExecutor);
             RDFConnection conn = catalog.getConnection();){
            List catalogRecords = (List)SparqlRx.execConstructGrouped(q -> conn.query(q), (Query)dcatQuery, (Node)Vars.a).map(RDFNode::asResource).toList().blockingGet();
            for (Resource catalogRecord : catalogRecords) {
                HashMap<CallSite, OpDataRefResource> nameToDataRef = new HashMap<CallSite, OpDataRefResource>();
                Query q2 = ((SparqlStmt)parser.apply("SELECT DISTINCT ?x { ?x dcat:distribution [] }")).getQuery();
                Model m = catalogRecord.getModel();
                List dcatDataRefs = (List)SparqlRx.execSelect(() -> QueryExecutionFactory.create((Query)q2, (Model)m)).map(qs -> qs.get("x")).map(RDFNode::asResource).toList().blockingGet();
                int i = 0;
                for (Resource r : dcatDataRefs) {
                    Model xxmodel = ModelFactory.createDefaultModel();
                    xxmodel.add(r.getModel());
                    r = r.inModel(xxmodel);
                    RdfDataRefDcat dr = RdfDataRefDcat.create((Model)xxmodel, (Resource)r);
                    OpDataRefResource drOp = OpDataRefResource.from((Model)xxmodel, (RdfDataRef)dr);
                    nameToDataRef.put((CallSite)((Object)("unnamedDataRef" + i++)), drOp);
                }
                logger.info("Registered data refs for input " + String.valueOf(catalogRecord) + " are: " + String.valueOf(nameToDataRef));
                HashMap<String, Model> nameToModel = new HashMap<String, Model>();
                nameToModel.put("http://input", catalogRecord.getModel());
                TaskContext taskContext = new TaskContext(catalogRecord, nameToDataRef, nameToModel);
                taskContexts.add(taskContext);
            }
            logger.info("Created " + taskContexts.size() + " task contexts");
        }
        return taskContexts;
    }

    public static List<DcatDataset> executeJob(RdfDataRef catalogDataRef, Job job, ConjureFormatConfig formatConfig) throws Exception {
        RDFFormat catalogFormat = formatConfig.getCatalogFormat();
        HttpResourceRepositoryFromFileSystemImpl repo = HttpResourceRepositoryFromFileSystemImpl.createDefault();
        ResourceStore cacheStore = repo.getCacheStore();
        List<TaskContext> taskContexts = MainCliConjureNative.createTasksContexts(catalogDataRef, job, (HttpResourceRepositoryFromFileSystem)repo, catalogFormat);
        List<DcatDataset> result = taskContexts.stream().map(taskContext -> ExecutionUtils.executeJob((Job)job, (TaskContext)taskContext, (HttpResourceRepositoryFromFileSystem)repo, (ResourceStore)cacheStore, (ConjureFormatConfig)formatConfig)).collect(Collectors.toList());
        return result;
    }

    public static Path resolveLocalUncFileUrl(String str, Set<String> localHostNames) {
        Path result = null;
        if (str.startsWith(URL_SCHEME_FILE)) {
            String host;
            URL url = null;
            try {
                url = new URL(str);
            }
            catch (MalformedURLException e) {
                logger.warn("Invalid URL", (Throwable)e);
            }
            if (url != null && localHostNames.contains(host = url.getHost())) {
                String pathStr = url.getPath();
                result = Paths.get(pathStr, new String[0]);
            }
        }
        return result;
    }

    public static Path stringToPath(String str) {
        Path result = str.startsWith(URL_SCHEME_FILE) ? Paths.get(str.substring(URL_SCHEME_FILE.length()), new String[0]) : null;
        return result;
    }

    public static NodeTransform asNodeTransform(Function<Path, String> pathToIri) {
        return o -> {
            String str = o.isURI() ? o.getURI() : (o.isLiteral() ? o.getLiteralLexicalForm() : null);
            Path path = str == null ? null : MainCliConjureNative.stringToPath(str);
            String iri = path == null ? null : (String)pathToIri.apply(path);
            Node r = iri == null ? o : NodeFactory.createURI((String)iri);
            return r;
        };
    }
}

