/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.conjure.cli.main;

import java.io.OutputStream;
import java.util.List;
import org.aksw.conjure.cli.main.MainCliConjureNative;
import org.aksw.dcat.jena.domain.api.DcatDataset;
import org.aksw.jena_sparql_api.conjure.dataref.rdf.api.RdfDataRef;
import org.aksw.jena_sparql_api.conjure.dataset.engine.ConjureConstants;
import org.aksw.jena_sparql_api.conjure.dataset.engine.ConjureFormatConfig;
import org.aksw.jena_sparql_api.conjure.job.api.Job;
import org.aksw.jenax.arq.util.node.NodeTransformLib2;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConfigCliConjureNative {
    @Bean
    @Autowired
    public ApplicationRunner applicationRunner(RdfDataRef catalogDataRef, Job job, ConjureFormatConfig formatConfig) {
        return args -> {
            List<DcatDataset> datasets = MainCliConjureNative.executeJob(catalogDataRef, job, formatConfig);
            Model model = ModelFactory.createDefaultModel();
            for (DcatDataset dataset : datasets) {
                Model contribModel = dataset.getModel();
                model.add(contribModel);
            }
            ConfigCliConjureNative.postProcessResultModel(model, job);
            RDFDataMgr.write((OutputStream)System.out, (Model)model, (RDFFormat)RDFFormat.TURTLE_PRETTY);
        };
    }

    public static void postProcessResultModel(Model model, Job job) {
        model.add(job.getModel());
        NodeTransformLib2.applyNodeTransform(n -> ConjureConstants.PROV_PLACEHOLDER_NODE.equals(n) ? job.asNode() : n, (Model)model);
    }
}

