/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.conjure.cli.config;

import com.google.common.base.StandardSystemProperty;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.conjure.cli.config.ConjureCliArgs;
import org.aksw.conjure.cli.config.SpringSourcesConfig;
import org.aksw.conjure.cli.main.CommandMain;
import org.aksw.conjure.cli.main.MainCliConjureNative;
import org.aksw.jena_sparql_api.conjure.dataset.engine.ConjureFormatConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConfigConjureSparkBase {
    @Bean
    @Autowired
    public ConjureCliArgs conjureMasterCliArgs(ApplicationArguments args) {
        ConjureCliArgs result = ConjureCliArgs.parse(args.getSourceArgs());
        return result;
    }

    @Bean
    @Autowired
    public ConjureFormatConfig formatConfig(ConjureCliArgs args) {
        ConjureFormatConfig result = new ConjureFormatConfig();
        return result;
    }

    @Bean
    @Autowired
    public SpringSourcesConfig conjureMasterConfig(ConjureCliArgs args) {
        SpringSourcesConfig result = ConfigConjureSparkBase.parseArgs(args);
        return result;
    }

    public static SpringSourcesConfig parseArgs(ConjureCliArgs args) {
        Path basePath = Paths.get(StandardSystemProperty.USER_DIR.value(), new String[0]);
        CommandMain cm = args.getCm();
        List<String> rawSources = cm.nonOptionArgs;
        Set<String> canonicalSources = rawSources.stream().map(rawSource -> MainCliConjureNative.canonicalizeSource(basePath, rawSource)).collect(Collectors.toSet());
        Map<String, byte[]> sourceToContent = MainCliConjureNative.loadSources(basePath, canonicalSources);
        SpringSourcesConfig result = new SpringSourcesConfig(canonicalSources, sourceToContent);
        return result;
    }
}

