/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.conjure.cli.config;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.conjure.cli.main.MainCliConjureNative;

public class SpringSourcesConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Set<String> sources;
    protected Map<String, byte[]> sourceToContent;

    public SpringSourcesConfig(Set<String> sources, Map<String, byte[]> sourceToContent) {
        this.sources = sources;
        this.sourceToContent = sourceToContent;
    }

    public Set<String> getSources() {
        return this.sources;
    }

    public Map<String, byte[]> getSourceToContent() {
        return this.sourceToContent;
    }

    public static Set<String> effectiveSources(Set<String> sources, Map<String, Path> fileSources) {
        Set remappedSources = fileSources.values().stream().map(MainCliConjureNative::toFileUri).collect(Collectors.toSet());
        Sets.SetView result = Sets.union((Set)Sets.difference(sources, fileSources.keySet()), remappedSources);
        return result;
    }
}

