/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.string;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.aksw.commons.util.entity.EntityInfo;
import org.aksw.commons.util.string.FileName;
import org.aksw.commons.util.string.FileNameImpl;

public class FileNameUtils {
    public static List<String> deconstruct(String filename) {
        List<String> result = Arrays.asList(filename.split("\\."));
        return result;
    }

    public static String construct(Iterable<String> parts) {
        String result = Streams.stream(parts).filter(str -> !str.isEmpty()).collect(Collectors.joining("."));
        return result;
    }

    public static FileName deriveFileName(String filename, EntityInfo entityInfo) {
        String baseName;
        String contentPart;
        List<String> encodingParts;
        List<String> parts = FileNameUtils.deconstruct(filename);
        int n = parts.size();
        int numEncodings = entityInfo.getContentEncodings().size();
        if (parts.size() >= numEncodings + 2) {
            int offset = n - numEncodings;
            encodingParts = parts.subList(offset--, n);
            contentPart = parts.get(offset);
            baseName = FileNameUtils.construct(parts.subList(0, offset));
        } else {
            encodingParts = Collections.emptyList();
            baseName = n >= 1 ? parts.get(0) : "";
            contentPart = n >= 2 ? parts.get(1) : "";
        }
        FileName result = FileNameImpl.create(baseName, contentPart, encodingParts);
        return result;
    }
}

