/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.reflect;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class MethodSignature {
    private String name;
    private Class<?> returnType;
    private List<Class<?>> parameterTypes;
    private boolean isVarArgs;

    public MethodSignature(Method m) {
        this.name = m.getName();
        this.returnType = m.getReturnType();
        this.parameterTypes = Arrays.asList(m.getParameterTypes());
        this.isVarArgs = m.isVarArgs();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isVarArgs ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parameterTypes == null ? 0 : this.parameterTypes.hashCode());
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSignature other = (MethodSignature)obj;
        if (this.isVarArgs != other.isVarArgs) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parameterTypes == null ? other.parameterTypes != null : !this.parameterTypes.equals(other.parameterTypes)) {
            return false;
        }
        return !(this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType));
    }
}

