/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.util.function.ThrowingRunnable;
import org.aksw.commons.util.reflect.MethodSignature;
import org.aksw.commons.util.traverse.BreadthFirstSearchLib;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtils {
    private static final Logger logger = LoggerFactory.getLogger(ClassUtils.class);

    public static Stream<Class<?>> getDirectSuperclassAndInterfaces(Class<?> cls) {
        return Stream.concat(Optional.ofNullable(cls.getSuperclass()).stream(), Stream.of(cls.getInterfaces()));
    }

    public static Stream<List<Class<?>>> bfsStream(Class<?> start) {
        return BreadthFirstSearchLib.stream(Collections.singletonList(start), ClassUtils::getDirectSuperclassAndInterfaces, () -> Collectors.toList());
    }

    public static <T> T getFieldValueChecked(Class<?> clazz, String fieldName, Object obj) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = clazz.getDeclaredField(fieldName);
        Object result = ClassUtils.accessCalc(field, () -> field.get(obj));
        return (T)result;
    }

    public static <T> T getFieldValue(Class<?> clazz, String fieldName, Object obj) {
        try {
            T result = ClassUtils.getFieldValueChecked(clazz, fieldName, obj);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getFieldValue(Object obj, String fieldName) {
        return ClassUtils.getFieldValue(obj.getClass(), fieldName, obj);
    }

    public static Field getModifiersField() throws IllegalAccessException, NoSuchFieldException {
        Field modifiersField = null;
        try {
            modifiersField = Field.class.getDeclaredField("modifiers");
        }
        catch (NoSuchFieldException e) {
            try {
                Field[] fields;
                Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                for (Field field : fields = ClassUtils.accessCalc(getDeclaredFields0, () -> (Field[])getDeclaredFields0.invoke(Field.class, false))) {
                    if (!"modifiers".equals(field.getName())) continue;
                    modifiersField = field;
                    break;
                }
                if (modifiersField == null) {
                    throw e;
                }
            }
            catch (NoSuchMethodException ex) {
                e.addSuppressed(ex);
                throw e;
            }
        }
        return modifiersField;
    }

    public static void setFieldValueChecked(Class<?> clazz, String fieldName, Object obj, Object value) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        Field field = clazz.getDeclaredField(fieldName);
        ClassUtils.access(field, () -> {
            if ((field.getModifiers() & 0x10) != 0) {
                Field modifiersField = ClassUtils.getModifiersField();
                ClassUtils.access(modifiersField, () -> modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF));
            }
            field.set(obj, value);
        });
    }

    public static void access(AccessibleObject obj, ThrowingRunnable consumer) {
        boolean isAccessible = obj.isAccessible();
        if (!isAccessible) {
            obj.setAccessible(true);
        }
        try {
            consumer.run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (!isAccessible) {
                obj.setAccessible(false);
            }
        }
    }

    public static <T> T accessCalc(AccessibleObject obj, Callable<T> consumer) {
        boolean isAccessible = obj.isAccessible();
        if (!isAccessible) {
            obj.setAccessible(true);
        }
        try {
            T result;
            T t = result = consumer.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (!isAccessible) {
                obj.setAccessible(false);
            }
        }
    }

    public static void setFieldValue(Class<?> clazz, String fieldName, Object obj, Object value) {
        try {
            ClassUtils.setFieldValueChecked(clazz, fieldName, obj, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        ClassUtils.setFieldValue(obj.getClass(), fieldName, null, value);
    }

    public static Object forceInvoke(Method m, Object[] args) {
        return ClassUtils.forceInvoke(null, m, args);
    }

    public static Object forceInvoke(Object o, Method m, Object ... args) {
        return ClassUtils.accessCalc(m, () -> m.invoke(o, args));
    }

    public static Integer getDistance(Class<?> given, Class<?> there) {
        int result = there.isInterface() ? ClassUtils._getDistanceInterface(given, there, 0) : ClassUtils._getDistanceClass(given, there);
        return result == Integer.MAX_VALUE ? null : Integer.valueOf(result);
    }

    private static int _getDistanceClass(Class<?> given, Class<?> there) {
        int distance = 0;
        do {
            if (given == there) {
                return distance;
            }
            ++distance;
        } while ((given = given.getSuperclass()) != null);
        return Integer.MAX_VALUE;
    }

    private static int _getDistanceInterface(Class<?> given, Class<?> there, int depth) {
        if (given == there) {
            return depth;
        }
        ++depth;
        int result = Integer.MAX_VALUE;
        for (Class<?> item : given.getInterfaces()) {
            result = Math.min(result, ClassUtils._getDistanceInterface(item, there, depth));
        }
        Class<?> superClass = given.getSuperclass();
        if (superClass != null) {
            result = Math.min(result, ClassUtils._getDistanceInterface(superClass, there, depth));
        }
        return result;
    }

    public static List<Class<?>> getTypeSignatureList(Object[] args) {
        ArrayList result = new ArrayList(args.length);
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            result.add(arg == null ? null : arg.getClass());
        }
        return result;
    }

    public static Class<?>[] getTypeSignature(Object[] args) {
        Class[] result = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            result[i] = arg == null ? null : arg.getClass();
        }
        return result;
    }

    public static Integer[] getDistance(Class<?>[] a, Class<?>[] b) {
        int n = Math.min(a.length, b.length);
        Integer[] result = new Integer[n];
        for (int i = 0; i < n; ++i) {
            Class<?> given = a[i];
            result[i] = given == null ? Integer.valueOf(0) : ClassUtils.getDistance(given, b[i]);
        }
        return result;
    }

    public static Integer[] getDistance(Class<?> ra, Class<?> rb, Class<?>[] a, Class<?>[] b) {
        int n = Math.min(a.length, b.length);
        Integer[] result = new Integer[n + 1];
        result[0] = ClassUtils.getDistance(rb, ra);
        for (int i = 0; i < n; ++i) {
            Integer d;
            result[i + 1] = d = ClassUtils.getDistance(a[i], b[i]);
        }
        return result;
    }

    public static Integer getRelation(Integer[] a, Integer[] b) {
        boolean hasGreater = false;
        boolean hasLess = false;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null || b[i] == null) {
                throw new NullPointerException();
            }
            int d = a[i] - b[i];
            if (d > 0) {
                hasGreater = true;
                continue;
            }
            if (d >= 0) continue;
            hasLess = true;
        }
        if (hasGreater && hasLess) {
            return null;
        }
        if (hasGreater) {
            return 1;
        }
        if (hasLess) {
            return -1;
        }
        return 0;
    }

    public static List<Method> getAllNonOverriddenMethods(Class<?> clazz) {
        List<Method> result = ClassUtils.getAllNonOverriddenMethods(clazz, null);
        return result;
    }

    public static List<Method> getAllNonOverriddenMethods(Class<?> clazz, String name) {
        ArrayList<Method> result = new ArrayList<Method>();
        HashSet<MethodSignature> signatures = new HashSet<MethodSignature>();
        while (clazz != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                MethodSignature signature;
                if (name != null && !method.getName().equals(name) || signatures.contains(signature = new MethodSignature(method))) continue;
                result.add(method);
                signatures.add(signature);
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public static Set<Class<?>> getMostSpecificSubclasses(Class<?> given, Collection<Class<?>> classes) {
        Set<Class<?>> tmp = classes.stream().filter(given::isAssignableFrom).collect(Collectors.toSet());
        Set<Class<?>> result = ClassUtils.getNonSubsumedClasses(tmp);
        return result;
    }

    public static Set<Class<?>> getNonSubsumedClasses(Collection<Class<?>> classes) {
        Set<Class<?>> result = classes.stream().filter(c -> classes.stream().filter(d -> !c.equals(d)).noneMatch(c::isAssignableFrom)).collect(Collectors.toSet());
        return result;
    }

    public static <T> Supplier<T> supplierFromCtor(Class<?> cls, boolean createTestInstance) {
        Constructor<?> ctor;
        try {
            ctor = cls.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        return ClassUtils.supplierFromCtor(ctor, createTestInstance);
    }

    public static <T> Supplier<T> supplierFromCtor(Constructor<?> ctor, boolean createTestInstance) {
        Supplier<Object> result = () -> {
            Object obj;
            try {
                obj = ctor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            Object r = obj;
            return r;
        };
        if (createTestInstance) {
            Object object = result.get();
        }
        return result;
    }
}

