/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.ref;

import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.aksw.commons.util.obj.ObjectUtils;
import org.aksw.commons.util.ref.Ref;
import org.aksw.commons.util.ref.RefImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonLazyRef<T>
implements Supplier<Ref<T>>,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(SingletonLazyRef.class);
    private static final long serialVersionUID = 1L;
    private static Map<String, Ref<?>> activeSingletons = new ConcurrentHashMap();
    protected String instanceId;
    protected Supplier<? extends Ref<T>> refSupplier;

    public SingletonLazyRef(String instanceId, Supplier<? extends Ref<T>> refSupplier) {
        this.instanceId = instanceId;
        this.refSupplier = refSupplier;
    }

    public static <T> SingletonLazyRef<T> create(String id, Supplier<? extends Ref<T>> refSupp) {
        return new SingletonLazyRef<T>(id, refSupp);
    }

    public static <T> SingletonLazyRef<T> create(Supplier<? extends Ref<T>> refSupp) {
        String id = String.valueOf(Instant.now()) + "_" + System.identityHashCode(refSupp) + "_" + refSupp.toString();
        return SingletonLazyRef.create(id, refSupp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref<T> get() {
        Ref<?> result;
        Map<String, Ref<?>> map = activeSingletons;
        synchronized (map) {
            Ref<Object> activeRef = activeSingletons.get(this.instanceId);
            if (activeRef == null) {
                Ref<T> delegateRef = this.refSupplier.get();
                logger.debug("Acquired singleton delegate " + ObjectUtils.toStringWithIdentityHashCode(delegateRef));
                activeRef = RefImpl.create(delegateRef.get(), activeSingletons, () -> {
                    delegateRef.close();
                    logger.debug("Closed singleton delegate " + ObjectUtils.toStringWithIdentityHashCode(delegateRef));
                    activeSingletons.remove(this.instanceId);
                });
                activeSingletons.put(this.instanceId, activeRef);
                result = activeRef;
            } else {
                result = activeRef.acquire();
            }
        }
        return result;
    }
}

