/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.ref;

import java.io.Serializable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Supplier;
import org.aksw.commons.util.ref.Ref;
import org.aksw.commons.util.ref.RefImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyRef<T>
implements Supplier<Ref<T>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(LazyRef.class);
    protected String label;
    protected Supplier<? extends Ref<T>> backendRefSupplier;
    protected long closeDelayInMs;
    protected volatile transient Ref<T> backendRef = null;
    protected volatile transient Ref<T> rootRef = null;
    protected volatile transient Timer timer = null;

    protected LazyRef() {
    }

    public LazyRef(String label, Supplier<? extends Ref<T>> backendRefSupplier, long closeDelayInMs) {
        this.label = label;
        this.backendRefSupplier = backendRefSupplier;
        this.closeDelayInMs = closeDelayInMs;
    }

    public static <T> LazyRef<T> create(String label, Supplier<? extends Ref<T>> rootRefFactory, long delayInMs) {
        return new LazyRef<T>(label, rootRefFactory, delayInMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref<T> get() {
        Ref<T> result;
        LazyRef lazyRef = this;
        synchronized (lazyRef) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            if (this.backendRef == null) {
                this.backendRef = this.backendRefSupplier.get();
            }
            if (this.rootRef == null) {
                this.rootRef = RefImpl.create(this.backendRef.get(), this, () -> {
                    this.rootRef = null;
                    if (this.timer == null) {
                        if (this.closeDelayInMs == 0L) {
                            this.actualClose();
                        } else {
                            this.timer = new Timer();
                            TimerTask timerTask = new TimerTask(){

                                @Override
                                public void run() {
                                    LazyRef.this.actualClose();
                                }
                            };
                            logger.debug(String.format("Deferring close of resource [%s] (backed by [%s]) by %d ms", this.label, this.backendRef, this.closeDelayInMs));
                            this.timer.schedule(timerTask, this.closeDelayInMs);
                        }
                    }
                });
                result = this.rootRef;
            } else {
                result = this.rootRef.acquire();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actualClose() {
        LazyRef lazyRef = this;
        synchronized (lazyRef) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            if (this.backendRef != null) {
                logger.debug(String.format("Imminent close of backing resource: [%s] %s", this.label, this.backendRef));
                this.backendRef.close();
                this.backendRef = null;
            }
        }
    }
}

