/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.range;

import com.google.common.collect.BoundType;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.math.LongMath;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.util.range.CountInfo;
import org.aksw.commons.util.range.Endpoint;
import org.aksw.commons.util.range.PageInfo;
import org.aksw.commons.util.range.RangeMapUtils;

public class RangeUtils {
    public static final Range<Long> rangeStartingWithZero = Range.atLeast((Comparable)Long.valueOf(0L));
    public static final Range<Long> RANGE_LONG = Range.closed((Comparable)Long.valueOf(Long.MIN_VALUE), (Comparable)Long.valueOf(Long.MAX_VALUE));

    public static long sizeLong(Range<Long> range) {
        Range r = range.intersection(RANGE_LONG).canonical(DiscreteDomain.longs());
        long start = (Long)r.lowerEndpoint();
        long end = (Long)r.upperEndpoint();
        long result = DiscreteDomain.longs().distance((Comparable)Long.valueOf(start), (Comparable)Long.valueOf(end));
        return result;
    }

    public static int intLength(Range<Long> range) {
        ContiguousSet set = ContiguousSet.create(range, (DiscreteDomain)DiscreteDomain.longs());
        int result = set.size();
        return result;
    }

    public static <T> List<T> subList(List<T> list, Range<Integer> subRange) {
        List result;
        Range listRange = Range.lessThan((Comparable)Integer.valueOf(list.size()));
        Range effectiveRange = listRange.intersection(subRange);
        ContiguousSet set = ContiguousSet.create((Range)effectiveRange, (DiscreteDomain)DiscreteDomain.integers());
        if (set.isEmpty()) {
            result = Collections.emptyList();
        } else {
            int first = (Integer)set.first();
            int last = (Integer)set.last();
            result = list.subList(first, last + 1);
        }
        return result;
    }

    public static <T extends Comparable<T>> Optional<T> tryGetSingleton(Range<T> range) {
        boolean isSingleton = RangeUtils.isSingleton(range);
        return Optional.ofNullable(isSingleton ? range.lowerEndpoint() : null);
    }

    public static boolean isDiscrete(RangeSet<?> rangeSet) {
        return RangeUtils.isDiscrete(rangeSet.asRanges());
    }

    public static boolean isDiscrete(Collection<? extends Range<?>> ranges) {
        boolean result = ranges.stream().allMatch(RangeUtils::isSingleton);
        return result;
    }

    public static boolean isSingleton(RangeSet<?> rangeSet) {
        return RangeUtils.isSingleton(rangeSet.asRanges());
    }

    public static boolean isSingleton(Collection<? extends Range<?>> ranges) {
        boolean result = ranges.size() == 1 && RangeUtils.isSingleton(ranges.iterator().next());
        return result;
    }

    public static boolean isSingleton(Range<?> range) {
        boolean result = range.hasLowerBound() && range.hasUpperBound() && range.lowerBoundType().equals((Object)BoundType.CLOSED) && range.upperBoundType().equals((Object)BoundType.CLOSED) && Objects.equals(range.lowerEndpoint(), range.upperEndpoint());
        return result;
    }

    public static long pickLong(Range<Long> range, Random random) {
        Range norm = range.intersection(Range.closed((Comparable)Long.valueOf(Long.MIN_VALUE), (Comparable)Long.valueOf(Long.MAX_VALUE)));
        long l = (Long)norm.lowerEndpoint();
        long u = (Long)norm.upperEndpoint();
        double pick = random.nextDouble();
        long result = l + Math.round(pick * (double)(u - l));
        return result;
    }

    public static double pickDouble(Range<Double> range, Random random) {
        Range norm = range.intersection(Range.closed((Comparable)Double.valueOf(Double.MIN_VALUE), (Comparable)Double.valueOf(Double.MAX_VALUE)));
        double l = (Double)norm.lowerEndpoint();
        double u = (Double)norm.upperEndpoint();
        double pick = random.nextDouble();
        double result = l + pick * (u - l);
        return result;
    }

    public static CountInfo toCountInfo(Range<? extends Number> range) {
        Long min = range.hasLowerBound() ? ((Number)((Object)range.lowerEndpoint())).longValue() : 0L;
        Long max = range.hasUpperBound() ? Long.valueOf(((Number)((Object)range.upperEndpoint())).longValue()) : null;
        CountInfo result = new CountInfo(min, max == null ? true : !max.equals(min), max);
        return result;
    }

    public static <C extends Comparable<C>> Range<C> makeAbsolute(Range<C> outer, Range<C> relative, DiscreteDomain<C> domain, BiFunction<C, Long, C> addition) {
        long distance = domain.distance(outer.lowerEndpoint(), relative.lowerEndpoint());
        Range<C> shifted = RangeUtils.shift(relative, distance, domain, addition);
        Range result = shifted.intersection(outer);
        return result;
    }

    public static Range<Long> shiftLong(Range<Long> rawRange, long distance) {
        return RangeUtils.map(rawRange, v -> v + distance);
    }

    public static <C extends Comparable<C>> Range<C> shift(Range<C> rawRange, long distance, DiscreteDomain<C> domain, BiFunction<C, Long, C> addition) {
        Range result;
        Range range = rawRange.canonical(domain);
        if (range.hasLowerBound()) {
            Comparable oldLower = range.lowerEndpoint();
            Comparable newLower = (Comparable)addition.apply(oldLower, distance);
            if (range.hasUpperBound()) {
                Comparable oldUpper = range.upperEndpoint();
                Comparable newUpper = (Comparable)addition.apply(oldUpper, distance);
                result = Range.closedOpen((Comparable)newLower, (Comparable)newUpper);
            } else {
                result = Range.atLeast((Comparable)oldLower);
            }
        } else {
            throw new IllegalArgumentException("Cannot displace a range without lower bound");
        }
        return result;
    }

    public static <K extends Comparable<K>, V> Set<Map.Entry<Range<K>, V>> getIntersectingRanges(Range<K> r, Collection<Map.Entry<Range<K>, V>> ranges) {
        Set<Map.Entry<Range<K>, V>> result = ranges.stream().filter(e -> !r.intersection((Range)e.getKey()).isEmpty()).collect(Collectors.toSet());
        return result;
    }

    public static Range<Long> startFromZero(Range<Long> range) {
        Range result = range.intersection(rangeStartingWithZero);
        return result;
    }

    public static <I extends Comparable<I>, O extends Comparable<O>, V> Range<O> apply(Range<I> range, V value, BiFunction<? super I, ? super V, ? extends O> op) {
        Range<Comparable> result = RangeUtils.map(range, endpoint -> (Comparable)op.apply((Object)endpoint, (Object)value));
        return result;
    }

    public static <I extends Comparable<I>, O extends Comparable<O>> Range<O> map(Range<I> range, Function<? super I, ? extends O> mapper) {
        Range result = range.hasLowerBound() ? (range.hasUpperBound() ? Range.range((Comparable)((Comparable)mapper.apply(range.lowerEndpoint())), (BoundType)range.lowerBoundType(), (Comparable)((Comparable)mapper.apply(range.upperEndpoint())), (BoundType)range.upperBoundType()) : Range.downTo((Comparable)((Comparable)mapper.apply(range.lowerEndpoint())), (BoundType)range.lowerBoundType())) : (range.hasUpperBound() ? Range.upTo((Comparable)((Comparable)mapper.apply(range.upperEndpoint())), (BoundType)range.upperBoundType()) : Range.all());
        return result;
    }

    public static <I extends Comparable<I>, O extends Comparable<O>> Range<O> map(Range<I> range, BiFunction<? super I, BoundType, Endpoint<? extends O>> lowerEndpointMapper, BiFunction<? super I, BoundType, Endpoint<? extends O>> upperEndpointMapper) {
        Endpoint<O> lower = range.hasLowerBound() ? lowerEndpointMapper.apply(range.lowerEndpoint(), range.lowerBoundType()) : null;
        Endpoint<O> upper = range.hasUpperBound() ? upperEndpointMapper.apply(range.upperEndpoint(), range.upperBoundType()) : null;
        Range<? extends O> result = RangeUtils.create(lower, upper);
        return result;
    }

    public static Range<Long> multiplyByPageSize(Range<Long> range, long pageSize) {
        Range<Long> result = RangeUtils.apply(range, pageSize, (endpoint, value) -> endpoint * value);
        return result;
    }

    public static PageInfo<Long> computeRange(Range<Long> range, long pageSize) {
        Range innerRange;
        Range outerRange;
        long o = range.hasLowerBound() ? (Long)range.lowerEndpoint() : 0L;
        long subOffset = o % pageSize;
        o -= subOffset;
        if (range.hasUpperBound()) {
            long limit = (Long)range.upperEndpoint() - (Long)range.lowerEndpoint();
            long l = limit;
            long mod = l % pageSize;
            long extra = mod != 0L ? pageSize - mod : 0L;
            outerRange = Range.closedOpen((Comparable)Long.valueOf(o), (Comparable)Long.valueOf(o + (l += extra)));
            innerRange = Range.closedOpen((Comparable)Long.valueOf(subOffset), (Comparable)Long.valueOf(limit));
        } else {
            outerRange = Range.atLeast((Comparable)Long.valueOf(o));
            innerRange = Range.atLeast((Comparable)Long.valueOf(subOffset));
        }
        PageInfo<Long> result = new PageInfo<Long>(outerRange, innerRange);
        return result;
    }

    public static <C extends Comparable<C>> RangeSet<C> gaps(Range<C> request, RangeSet<C> ranges) {
        RangeSet gaps = ranges.complement().subRangeSet(request);
        return gaps;
    }

    public static NavigableMap<Long, Long> scheduleRangeSupply(NavigableMap<Long, Long> supplyOffsetToEndpoint, RangeSet<Long> demandGaps, long maxRedundantSize, long maxSupplierRange) {
        boolean enableSanityCheck;
        TreeMap<Long, Long> offsetToEndpoint = new TreeMap<Long, Long>((SortedMap<Long, Long>)supplyOffsetToEndpoint);
        TreeMap<Long, Long> result = new TreeMap<Long, Long>();
        TreeSet<Object> allSplitPoints = new TreeSet<Object>();
        Set startPoints = offsetToEndpoint.keySet();
        Collection endPoints = offsetToEndpoint.values();
        allSplitPoints.addAll(startPoints);
        allSplitPoints.addAll(endPoints);
        RangeMap gapRangeMap = RangeMapUtils.create(demandGaps.asRanges());
        RangeMapUtils.split(gapRangeMap, allSplitPoints);
        Set gapSet = gapRangeMap.asMapOfRanges().keySet();
        long bestOffset = -1L;
        long bestMaxEnd = -1L;
        long bestCurEnd = -1L;
        for (Range gap : gapSet) {
            ContiguousSet tmp = ContiguousSet.create((Range)gap, (DiscreteDomain)DiscreteDomain.longs());
            long l = (Long)tmp.first();
            long gapEnd = LongMath.saturatedAdd((long)((Long)tmp.last()), (long)1L);
            while (l < gapEnd) {
                if (bestOffset >= 0L) {
                    if (gapEnd < bestMaxEnd) {
                        long d = l - bestCurEnd;
                        if (d <= maxRedundantSize) {
                            bestCurEnd = gapEnd;
                        } else {
                            result.put(bestOffset, bestCurEnd);
                            bestOffset = -1L;
                        }
                    } else {
                        Long reallocateOffset = RangeUtils.streamEnclosingRanges(offsetToEndpoint, bestOffset, gapEnd).findFirst().orElse(null);
                        if (reallocateOffset == null) {
                            if (bestOffset >= 0L) {
                                result.put(bestOffset, bestCurEnd);
                            }
                            bestOffset = -1L;
                        } else {
                            bestOffset = reallocateOffset;
                            bestMaxEnd = (Long)offsetToEndpoint.get(reallocateOffset);
                            bestCurEnd = Math.min(gapEnd, bestMaxEnd);
                        }
                    }
                }
                if (bestOffset < 0L) {
                    Long candOffset = RangeUtils.streamEnclosingRanges(offsetToEndpoint, l, gapEnd).findFirst().orElse(null);
                    if (candOffset != null) {
                        bestOffset = candOffset;
                        bestMaxEnd = (Long)offsetToEndpoint.get(candOffset);
                        bestCurEnd = Math.min(gapEnd, bestMaxEnd);
                    } else {
                        bestOffset = l;
                        bestMaxEnd = LongMath.saturatedAdd((long)l, (long)maxSupplierRange);
                        bestCurEnd = Math.min(gapEnd, bestMaxEnd);
                    }
                }
                l = bestCurEnd;
            }
        }
        if (bestOffset >= 0L) {
            result.put(bestOffset, bestCurEnd);
        }
        if (enableSanityCheck = true) {
            TreeRangeSet scheduledRanges = TreeRangeSet.create();
            for (Map.Entry entry : result.entrySet()) {
                scheduledRanges.add(Range.closedOpen((Comparable)((Long)entry.getKey()), (Comparable)((Long)entry.getValue())));
            }
            boolean isEveryGapCovered = scheduledRanges.enclosesAll(gapSet);
            if (!isEveryGapCovered) {
                throw new RuntimeException("Sanity check failed");
            }
        }
        return result;
    }

    public static Stream<Long> streamEnclosingRanges(NavigableMap<Long, Long> offsetToEndpoint, long start, long end) {
        NavigableMap<Long, Long> headMap = offsetToEndpoint.headMap(start, true).descendingMap();
        Stream<Long> result = headMap.entrySet().stream().filter(offsetAndEndpoint -> {
            long supplyEnd = (Long)offsetAndEndpoint.getValue();
            boolean isEnclosing = supplyEnd >= end;
            return isEnclosing;
        }).map(Map.Entry::getKey);
        return result;
    }

    public static Range<Long> createRange(Long limit, Long offset) {
        long beginIndex = offset == null ? 0L : offset;
        Long endIndex = limit == null ? null : Long.valueOf(beginIndex + limit);
        Range result = endIndex == null ? Range.atLeast((Comparable)Long.valueOf(beginIndex)) : Range.closedOpen((Comparable)Long.valueOf(beginIndex), (Comparable)endIndex);
        return result;
    }

    public static <T extends Comparable<T>> Range<T> create(T lower, BoundType lowerType, T upper, BoundType upperType) {
        Range result = lower == null ? (upper == null ? Range.all() : Range.upTo(upper, (BoundType)upperType)) : (upper == null ? Range.downTo(lower, (BoundType)lowerType) : Range.range(lower, (BoundType)lowerType, upper, (BoundType)upperType));
        return result;
    }

    public static <T extends Comparable<T>> Range<T> create(Endpoint<? extends T> lower, Endpoint<? extends T> upper) {
        return RangeUtils.create(lower == null ? null : (Comparable)lower.getValue(), lower == null ? null : lower.getBoundType(), upper == null ? null : (Comparable)upper.getValue(), upper == null ? null : upper.getBoundType());
    }

    public static <T extends Comparable<T>> Endpoint<T> getLowerEndpoint(Range<T> range) {
        Endpoint<Comparable> result = range.hasLowerBound() ? new Endpoint<Comparable>(range.lowerEndpoint(), range.lowerBoundType()) : new Endpoint<Object>(null, BoundType.OPEN);
        return result;
    }

    public static <T extends Comparable<T>> Endpoint<T> getUpperEndpoint(Range<T> range) {
        Endpoint<Comparable> result = range.hasUpperBound() ? new Endpoint<Comparable>(range.upperEndpoint(), range.upperBoundType()) : new Endpoint<Object>(null, BoundType.OPEN);
        return result;
    }

    public static <C extends Comparable<C>> int compareToLowerBound(Range<C> a, Range<C> b) {
        return a.hasLowerBound() ? (b.hasLowerBound() ? a.lowerEndpoint().compareTo(b.lowerEndpoint()) : 1) : (b.hasLowerBound() ? -1 : 0);
    }

    public static <C extends Comparable<C>> int compareToUpperBound(Range<C> a, Range<C> b) {
        return a.hasUpperBound() ? (b.hasUpperBound() ? a.upperEndpoint().compareTo(b.upperEndpoint()) : -1) : (b.hasUpperBound() ? 1 : 0);
    }

    public static double randomDouble(Range<? extends Number> range, Random random) {
        double min = range.hasLowerBound() ? ((Number)((Object)range.lowerEndpoint())).doubleValue() : Double.MIN_VALUE;
        double max = range.hasUpperBound() ? ((Number)((Object)range.upperEndpoint())).doubleValue() : Double.MAX_VALUE;
        double f = random.nextDouble();
        double result = min + (max - min) * f;
        return result;
    }
}

